/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.capture;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.util.Minecrft;
import java.io.IOException;
import net.minecraft.class_276;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CaptureShader {
    @Nullable
    private static class_279 shader = null;

    public static boolean hasShader() {
        return shader != null;
    }

    public static void apply(class_2960 shaderLocation) {
        if (shader != null) {
            if (shader.method_1260().equals(shaderLocation.toString())) {
                return;
            }
            shader.close();
        }
        try {
            class_310 minecraft = Minecrft.get();
            shader = new class_279(minecraft.method_1531(), (class_5912)minecraft.method_1478(), minecraft.method_1522(), shaderLocation);
            shader.method_1259(minecraft.method_22683().method_4489(), minecraft.method_22683().method_4506());
        }
        catch (IOException e) {
            Exposure.LOGGER.warn("Failed to load shader: {}", (Object)shaderLocation, (Object)e);
            CaptureShader.remove();
        }
        catch (JsonSyntaxException e) {
            Exposure.LOGGER.warn("Failed to parse shader: {}", (Object)shaderLocation, (Object)e);
            CaptureShader.remove();
        }
    }

    public static void resize(int width, int height) {
        if (shader != null) {
            shader.method_1259(width, height);
        }
    }

    public static void process() {
        if (shader != null) {
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            shader.method_1258(Minecrft.get().method_60646().method_60636());
        }
    }

    public static void process(class_276 renderTarget) {
        if (shader != null) {
            CaptureShader.process(shader, renderTarget);
        }
    }

    public static void process(@NotNull class_279 shader, @NotNull class_276 renderTarget) {
        try {
            class_2960 shaderLocation = class_2960.method_60654((String)shader.method_1260());
            class_279 tempShader = new class_279(Minecrft.get().method_1531(), (class_5912)Minecrft.get().method_1478(), renderTarget, shaderLocation);
            tempShader.method_1259(renderTarget.field_1482, renderTarget.field_1481);
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            tempShader.method_1258(Minecrft.get().method_60646().method_60636());
            tempShader.close();
        }
        catch (IOException e) {
            Exposure.LOGGER.warn("Failed to load shader: {}", (Object)shader.method_1260(), (Object)e);
        }
        catch (JsonSyntaxException e) {
            Exposure.LOGGER.warn("Failed to parse shader: {}", (Object)shader.method_1260(), (Object)e);
        }
    }

    public static void remove() {
        if (shader != null) {
            shader.close();
        }
        shader = null;
    }
}

