/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.camera.viewfinder;

import com.google.gson.JsonSyntaxException;
import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.client.camera.viewfinder.Viewfinder;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.Filter;
import io.github.mortuusars.exposure.data.Filters;
import io.github.mortuusars.exposure.world.camera.Camera;
import io.github.mortuusars.exposure.world.item.camera.Attachment;
import java.io.IOException;
import net.minecraft.class_1799;
import net.minecraft.class_279;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_5912;
import org.jetbrains.annotations.Nullable;

public class ViewfinderShader
implements AutoCloseable {
    private final class_310 minecraft = Minecrft.get();
    private final Camera camera;
    private final Viewfinder viewfinder;
    @Nullable
    private class_279 shader;
    private boolean active;

    public ViewfinderShader(Camera camera, Viewfinder viewfinder) {
        this.camera = camera;
        this.viewfinder = viewfinder;
        this.update();
    }

    public void apply(class_2960 shaderLocation) {
        if (this.shader != null) {
            if (this.shader.method_1260().equals(shaderLocation.toString())) {
                return;
            }
            this.shader.close();
        }
        try {
            this.shader = new class_279(this.minecraft.method_1531(), (class_5912)this.minecraft.method_1478(), this.minecraft.method_1522(), shaderLocation);
            this.shader.method_1259(this.minecraft.method_22683().method_4489(), this.minecraft.method_22683().method_4506());
            this.active = true;
        }
        catch (IOException e) {
            Exposure.LOGGER.warn("Failed to load shader: {}", (Object)shaderLocation, (Object)e);
            this.active = false;
        }
        catch (JsonSyntaxException e) {
            Exposure.LOGGER.warn("Failed to parse shader: {}", (Object)shaderLocation, (Object)e);
            this.active = false;
        }
    }

    public void resize(int width, int height) {
        if (this.shader != null) {
            this.shader.method_1259(width, height);
        }
    }

    public void process() {
        if (this.shader != null && this.active) {
            RenderSystem.disableBlend();
            RenderSystem.disableDepthTest();
            RenderSystem.resetTextureMatrix();
            this.shader.method_1258(this.minecraft.method_60646().method_60636());
        }
    }

    public void update() {
        this.setActive(this.viewfinder.isLookingThrough());
        if (this.active) {
            class_1799 filterStack = Attachment.FILTER.get(this.camera.getItemStack()).getForReading();
            Filters.of(Minecrft.registryAccess(), filterStack).map(Filter::shader).ifPresentOrElse(this::apply, this::remove);
        }
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public void remove() {
        if (this.shader != null) {
            this.shader.close();
        }
        this.shader = null;
    }

    @Override
    public void close() {
        this.remove();
    }
}

