/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.util;

import com.mojang.serialization.Codec;
import io.netty.buffer.ByteBuf;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntOpenHashMap;
import java.util.ArrayList;
import java.util.List;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.init.ModEnchantments;
import moriyashiine.enchancement.common.tag.ModItemTags;
import moriyashiine.enchancement.common.util.SubmersionGate;
import net.fabricmc.fabric.api.item.v1.EnchantingContext;
import net.fabricmc.fabric.api.tag.convention.v2.ConventionalFluidTags;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1542;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1738;
import net.minecraft.class_1740;
import net.minecraft.class_1741;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1831;
import net.minecraft.class_1834;
import net.minecraft.class_1887;
import net.minecraft.class_1890;
import net.minecraft.class_1893;
import net.minecraft.class_2246;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2588;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_5321;
import net.minecraft.class_5819;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7417;
import net.minecraft.class_7876;
import net.minecraft.class_7923;
import net.minecraft.class_8046;
import net.minecraft.class_9139;
import net.minecraft.class_9304;
import net.minecraft.class_9331;
import net.minecraft.class_9334;
import net.minecraft.class_9698;
import net.minecraft.class_9723;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.jetbrains.annotations.Nullable;

public class EnchancementUtil {
    public static class_7876<?> ENCHANTMENT_REGISTRY_OWNER = null;
    public static final List<class_6880.class_6883<class_1887>> ENCHANTMENTS = new ArrayList<class_6880.class_6883<class_1887>>();
    public static final Object2IntMap<class_1887> ORIGINAL_MAX_LEVELS = new Object2IntOpenHashMap();
    public static final Codec<class_243> VEC3D_CODEC = Codec.DOUBLE.listOf().comapFlatMap(list -> class_156.method_33141((List)list, (int)3).map(listX -> new class_243(((Double)listX.getFirst()).doubleValue(), ((Double)listX.get(1)).doubleValue(), ((Double)listX.get(2)).doubleValue())), vec3d -> List.of(Double.valueOf(vec3d.method_10216()), Double.valueOf(vec3d.method_10214()), Double.valueOf(vec3d.method_10215())));
    public static final class_9139<ByteBuf, class_243> VEC3D_PACKET_CODEC = new class_9139<ByteBuf, class_243>(){

        public class_243 decode(ByteBuf buf) {
            return new class_243(buf.readDouble(), buf.readDouble(), buf.readDouble());
        }

        public void encode(ByteBuf buf, class_243 value) {
            buf.writeDouble(value.method_10216());
            buf.writeDouble(value.method_10214());
            buf.writeDouble(value.method_10215());
        }
    };
    public static class_1799 cachedApplyStack = null;
    public static boolean shouldCancelTargetDamagedEnchantments = false;

    public static List<class_1542> mergeItemEntities(List<class_1542> drops) {
        for (int i = drops.size() - 1; i >= 0; --i) {
            if (i >= drops.size() - 1) continue;
            class_1542 itemEntity = drops.get(i);
            class_1542 other = drops.get(i + 1);
            itemEntity.method_6972(other);
            if (itemEntity.method_6983().method_7960()) {
                drops.remove(i);
            }
            if (!other.method_6983().method_7960()) continue;
            drops.remove(i + 1);
        }
        return drops;
    }

    public static String getTranslationKey(class_6880<class_1887> enchantment) {
        class_7417 class_74172 = ((class_1887)enchantment.comp_349()).comp_2686().method_10851();
        if (class_74172 instanceof class_2588) {
            class_2588 translatable = (class_2588)class_74172;
            return translatable.method_11022();
        }
        return ((class_1887)enchantment.comp_349()).comp_2686().getString();
    }

    @Nullable
    public static class_6880<class_1887> getRandomEnchantment(class_1799 stack, class_5819 random) {
        ArrayList<class_6880> enchantments = new ArrayList<class_6880>();
        for (class_6880 class_68802 : ENCHANTMENTS) {
            if (!stack.method_31574(class_1802.field_8529) && !stack.method_31574(class_1802.field_8598) && !stack.canBeEnchantedWith(class_68802, EnchantingContext.ACCEPTABLE)) continue;
            enchantments.add(class_68802);
        }
        if (!enchantments.isEmpty()) {
            return (class_6880)enchantments.get(random.method_43048(enchantments.size()));
        }
        return null;
    }

    @Nullable
    public static class_6880<class_1887> getReplacement(class_6880<class_1887> enchantment, class_1799 stack) {
        if (enchantment.method_40230().isEmpty()) {
            return null;
        }
        ArrayList<class_6880> enchantments = new ArrayList<class_6880>();
        for (class_6880 class_68802 : ENCHANTMENTS) {
            if (!EnchancementUtil.isEnchantmentAllowed((class_6880<class_1887>)class_68802) || !stack.method_31574(class_1802.field_8529) && !stack.method_31574(class_1802.field_8598) && !stack.canBeEnchantedWith(class_68802, EnchantingContext.ACCEPTABLE)) continue;
            enchantments.add(class_68802);
        }
        if (enchantments.isEmpty()) {
            return null;
        }
        int index = (((class_5321)enchantment.method_40230().get()).method_29177().hashCode() + class_7923.field_41178.method_10221((Object)stack.method_7909()).hashCode()) % enchantments.size();
        if (index < 0) {
            index += enchantments.size();
        }
        return (class_6880)enchantments.get(index);
    }

    public static boolean isEnchantmentAllowed(class_6880<class_1887> enchantment) {
        if (enchantment.method_40230().isPresent()) {
            return EnchancementUtil.isEnchantmentAllowed(((class_5321)enchantment.method_40230().get()).method_29177());
        }
        return false;
    }

    public static boolean isEnchantmentAllowed(class_2960 identifier) {
        if (identifier.equals((Object)ModEnchantments.EMPTY_KEY.method_29177())) {
            return false;
        }
        if (ModConfig.invertedList) {
            return ModConfig.disallowedEnchantments.contains(identifier.toString());
        }
        return !ModConfig.disallowedEnchantments.contains(identifier.toString());
    }

    public static boolean hasWeakEnchantments(class_1799 stack) {
        class_1792 material;
        if (stack.method_31573(ModItemTags.STRONGLY_ENCHANTED)) {
            return false;
        }
        if (stack.method_31573(ModItemTags.WEAKLY_ENCHANTED)) {
            return true;
        }
        class_1792 class_17922 = stack.method_7909();
        if (class_17922 instanceof class_1738) {
            class_1738 armorItem = (class_1738)class_17922;
            material = (class_1741)armorItem.method_7686().comp_349();
            for (class_1741 mat : class_7923.field_48976) {
                if (material != mat) continue;
                return mat == class_1740.field_7897.comp_349() || mat == class_1740.field_7892.comp_349();
            }
            return material.comp_2299() <= ((class_1741)class_1740.field_7892.comp_349()).comp_2299();
        }
        material = stack.method_7909();
        if (material instanceof class_1831) {
            class_1831 toolItem = (class_1831)material;
            material = toolItem.method_8022();
            for (class_1834 mat : class_1834.values()) {
                if (material != mat) continue;
                return mat == class_1834.field_8922 || mat == class_1834.field_8927 || mat == class_1834.field_8923;
            }
            return material.method_8026() <= class_1834.field_8923.method_8026();
        }
        return false;
    }

    public static int alterLevel(class_1799 stack, class_6880<class_1887> enchantment) {
        if (ModConfig.singleLevelMode && (enchantment.method_40225(class_1893.field_9104) || enchantment.method_40225(class_1893.field_50159))) {
            return 1;
        }
        return EnchancementUtil.getModifiedMaxLevel(stack, EnchancementUtil.getOriginalMaxLevel(enchantment));
    }

    public static int getModifiedMaxLevel(class_1799 stack, int maxLevel) {
        if (EnchancementUtil.hasWeakEnchantments(stack)) {
            return class_3532.method_15386((float)((float)maxLevel / 2.0f));
        }
        return maxLevel;
    }

    public static int getOriginalMaxLevel(class_6880<class_1887> enchantment) {
        return ORIGINAL_MAX_LEVELS.getOrDefault(enchantment.comp_349(), ((class_1887)enchantment.comp_349()).method_8183());
    }

    public static boolean isDefaultEnchantment(class_1799 stack, class_6880<class_1887> enchantment) {
        class_9304 defaultEnchantments = (class_9304)stack.method_7909().method_57347().method_57830(class_9334.field_49633, (Object)class_9304.field_49385);
        for (class_6880 foundEnchantment : defaultEnchantments.method_57534()) {
            int level;
            if (foundEnchantment != enchantment || (level = ModConfig.singleLevelMode ? 1 : class_1890.method_8225(enchantment, (class_1799)stack)) != defaultEnchantments.method_57536(enchantment)) continue;
            return true;
        }
        return false;
    }

    public static boolean exceedsLimit(class_1799 stack, int size) {
        if (ModConfig.enchantmentLimit == 0) {
            return false;
        }
        for (class_6880 enchantment : class_1890.method_57532((class_1799)stack).method_57534()) {
            if (!EnchancementUtil.isDefaultEnchantment(stack, (class_6880<class_1887>)enchantment)) continue;
            --size;
        }
        return size > ModConfig.enchantmentLimit;
    }

    public static boolean isUnbreakable(class_1799 stack) {
        return ModConfig.disableDurability && !stack.method_7960() && stack.method_57826(class_9334.field_50072) && !stack.method_31573(ModItemTags.RETAINS_DURABILITY);
    }

    public static boolean canSee(class_1297 host, class_1297 target, int range) {
        if (target.method_37908() == host.method_37908() && host.method_19538().method_1022(target.method_19538()) <= 32.0) {
            for (int i = -range; i <= range; ++i) {
                if (host.method_37908().method_17742(new class_3959(host.method_19538().method_1031(0.0, (double)i, 0.0), target.method_19538().method_1031(0.0, (double)i, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1348, host)).method_17783() != class_239.class_240.field_1333) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean isGroundedOrAirborne(class_1309 living, boolean allowWater) {
        if (living instanceof class_1657) {
            class_1657 player = (class_1657)living;
            if (player.method_31549().field_7479) {
                return false;
            }
        }
        if (!allowWater && (living.method_5799() || living.method_5681())) {
            return false;
        }
        return !living.method_6128() && living.method_5854() == null && !living.method_6101();
    }

    public static boolean isGroundedOrAirborne(class_1309 living) {
        return EnchancementUtil.isGroundedOrAirborne(living, false);
    }

    public static boolean isSubmerged(class_1297 entity, SubmersionGate gate) {
        for (int i = 0; i < class_3532.method_15386((float)entity.method_17682()); ++i) {
            class_2680 blockState = entity.method_37908().method_8320(entity.method_24515().method_10086(i));
            if (gate.allowsWater() && !blockState.method_27852(class_2246.field_10422) && blockState.method_26227().method_15767(ConventionalFluidTags.WATER)) {
                return true;
            }
            if (gate.allowsLava() && blockState.method_26227().method_15767(ConventionalFluidTags.LAVA)) {
                return true;
            }
            if (!gate.allowsPowderSnow() || !blockState.method_27852(class_2246.field_27879)) continue;
            return true;
        }
        return false;
    }

    public static boolean isSufficientlyHigh(class_1297 entity, double distanceFromGround) {
        return entity.method_37908().method_17742(new class_3959(entity.method_19538(), entity.method_19538().method_1031(0.0, -distanceFromGround, 0.0), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, entity)).method_17783() == class_239.class_240.field_1333;
    }

    public static boolean shouldHurt(class_1297 attacker, class_1297 hitEntity) {
        if (attacker == null || hitEntity == null) {
            return true;
        }
        if (attacker == hitEntity || attacker.method_5854() == hitEntity) {
            return false;
        }
        if (hitEntity instanceof class_1657) {
            class_1657 hitPlayer = (class_1657)hitEntity;
            if (attacker instanceof class_1657) {
                class_1657 attackingPlayer = (class_1657)attacker;
                return attackingPlayer.method_7256(hitPlayer);
            }
        }
        if (hitEntity instanceof class_8046) {
            class_8046 ownable = (class_8046)hitEntity;
            return EnchancementUtil.shouldHurt(attacker, ownable.method_24921());
        }
        return true;
    }

    public static int getFlooredHealth(class_1309 living) {
        float percentage = living.method_6032() / living.method_6063();
        return (int)Math.floor((double)(percentage * 10.0f) + 0.5);
    }

    public static boolean hasAnyEnchantmentsIn(class_1297 entity, class_6862<class_1887> tag) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            for (class_1799 stack : living.method_5661()) {
                if (!class_1890.method_60138((class_1799)stack, tag)) continue;
                return true;
            }
        }
        return false;
    }

    public static boolean hasAnyEnchantmentsWith(class_1297 entity, class_9331<?> componentType) {
        if (entity instanceof class_1309) {
            class_1309 living = (class_1309)entity;
            for (class_1799 stack : living.method_5661()) {
                if (!class_1890.method_60142((class_1799)stack, componentType)) continue;
                return true;
            }
        }
        return false;
    }

    public static float getValue(class_9331<class_9723> component, class_5819 random, class_1799 stack, float base) {
        MutableFloat mutableFloat = new MutableFloat(base);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60506(component, random, level, mutableFloat));
        return mutableFloat.floatValue();
    }

    public static float getValue(class_9331<class_9723> component, class_1309 entity, float base) {
        MutableFloat mutableFloat = new MutableFloat(base);
        for (class_1799 stack : entity.method_5661()) {
            class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60506(component, entity.method_59922(), level, mutableFloat));
        }
        return mutableFloat.floatValue();
    }

    public static float getValue(class_9331<List<class_9698<class_9723>>> component, class_3218 world, class_1799 stack, float base) {
        MutableFloat mutableFloat = new MutableFloat(base);
        class_1890.method_8220((class_1799)stack, (enchantment, level) -> ((class_1887)enchantment.comp_349()).method_60037(component, world, level, stack, mutableFloat));
        return mutableFloat.floatValue();
    }
}

