/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.entity.projectile;

import java.util.HashSet;
import java.util.Set;
import moriyashiine.enchancement.client.payload.PlayBrimstoneTravelSoundPayload;
import moriyashiine.enchancement.common.init.ModComponentTypes;
import moriyashiine.enchancement.common.init.ModDamageTypes;
import moriyashiine.enchancement.common.init.ModEntityTypes;
import moriyashiine.enchancement.common.init.ModParticleTypes;
import moriyashiine.enchancement.common.tag.ModEntityTypeTags;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1665;
import net.minecraft.class_174;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_2390;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import net.minecraft.class_5712;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.Nullable;
import org.joml.Vector3f;

public class BrimstoneEntity
extends class_1665 {
    public static final class_1799 BRIMSTONE_STACK;
    public static final int DISTANCE_PER_TICK = 6;
    public static boolean ALWAYS_SPAWN_PARTICLES;
    public static final class_2940<Float> DAMAGE;
    public static final class_2940<Float> FORCED_PITCH;
    public static final class_2940<Float> FORCED_YAW;
    private static final class_2390 PARTICLE;
    public int distanceTraveled = 0;
    public int ticksExisted = 0;
    private final Set<class_1297> hitEntities = new HashSet<class_1297>();

    public static int getMaxTicks() {
        return class_3532.method_15375((float)42.666668f);
    }

    public BrimstoneEntity(class_1299<? extends class_1665> entityType, class_1937 world) {
        super(entityType, world);
        this.field_5985 = true;
    }

    public BrimstoneEntity(class_1937 world, class_1309 owner, @Nullable class_1799 shotFrom) {
        super(ModEntityTypes.BRIMSTONE, owner, world, class_1799.field_8037, shotFrom);
        this.method_5814(owner.method_23317(), owner.method_23320() - 0.3, owner.method_23321());
        this.field_5985 = true;
    }

    protected class_1799 method_57314() {
        return class_1799.field_8037;
    }

    public void method_5773() {
        if (!this.method_37908().field_9236 && this.ticksExisted == 0) {
            PlayerLookup.all((MinecraftServer)this.method_37908().method_8503()).forEach(foundPlayer -> PlayBrimstoneTravelSoundPayload.send(foundPlayer, (class_1297)this));
        }
        if (this.method_7443()) {
            this.method_7439(false);
        }
        this.method_18799(class_243.field_1353);
        for (int i = 0; i < 6; ++i) {
            float min = Math.min(this.distanceTraveled, this.ticksExisted);
            if (min > 0.0f && min == (float)this.distanceTraveled) {
                this.method_31472();
            }
            class_243 start = this.method_19538().method_1019(this.method_5720().method_1021((double)(this.distanceTraveled + (this.ticksExisted > 0 ? -1 : 0))));
            class_243 end = start.method_1019(this.method_5720());
            class_3965 hitResult = this.method_37908().method_17742(new class_3959(start, end, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, (class_1297)this));
            if (hitResult.method_17783() == class_239.class_240.field_1332) {
                if (this.method_37908().field_9236) {
                    this.addParticles((class_2394)PARTICLE, hitResult.method_17784().method_10216(), hitResult.method_17784().method_10214(), hitResult.method_17784().method_10215());
                    break;
                }
                this.method_37908().method_32888((class_6880)class_5712.field_28162, hitResult.method_17784(), class_5712.class_7397.method_43285((class_1297)this));
                break;
            }
            class_1297 owner = this.method_24921();
            this.method_37908().method_8333(owner, class_238.method_29968((class_243)hitResult.method_17784()).method_1014(0.5), class_1301.field_6155.and(entity -> this.canEntityBeHit(owner, (class_1297)entity))).forEach(entity -> {
                if (this.method_37908().field_9236) {
                    this.addParticles((class_2394)PARTICLE, entity.method_23317(), entity.method_23319(), entity.method_23321());
                } else {
                    double damage = this.method_7448();
                    if (entity instanceof class_1309) {
                        class_1309 living = (class_1309)entity;
                        damage *= (double)(living.method_6063() / 20.0f);
                    }
                    damage *= (double)this.getDamageMultiplier(this.distanceTraveled);
                    damage = Math.min(50.0, damage);
                    entity.method_5643(ModDamageTypes.create(this.method_37908(), ModDamageTypes.BRIMSTONE, (class_1297)this, owner), (float)damage);
                    this.hitEntities.add((class_1297)entity);
                    class_1297 patt0$temp = this.method_24921();
                    if (patt0$temp instanceof class_3222) {
                        class_3222 player = (class_3222)patt0$temp;
                        if (entity instanceof class_1309) {
                            class_1309 living = (class_1309)entity;
                            class_174.field_1197.method_8980(player, Set.of(living));
                        }
                    }
                }
            });
            ++this.distanceTraveled;
        }
        if (this.method_37908().field_9236) {
            class_243 particlePos = this.method_19538().method_1019(this.method_5720().method_1021((double)this.distanceTraveled));
            this.addParticles((class_2394)PARTICLE, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215());
            this.addParticles((class_2394)ModParticleTypes.BRIMSTONE_BUBBLE, particlePos.method_10216(), particlePos.method_10214(), particlePos.method_10215());
        } else if (this.ticksExisted > BrimstoneEntity.getMaxTicks()) {
            this.method_31472();
        }
        ++this.ticksExisted;
    }

    protected void method_7454(class_3966 entityHitResult) {
    }

    protected void method_24920(class_3965 blockHitResult) {
    }

    public void method_5749(class_2487 nbt) {
        super.method_5749(nbt);
        this.method_7438(nbt.method_10583("Damage"));
        this.field_6011.method_12778(FORCED_PITCH, (Object)Float.valueOf(nbt.method_10583("ForcedPitch")));
        this.field_6011.method_12778(FORCED_YAW, (Object)Float.valueOf(nbt.method_10583("ForcedYaw")));
        this.distanceTraveled = nbt.method_10550("DistanceTraveled");
        this.ticksExisted = nbt.method_10550("TicksExisted");
    }

    public void method_5652(class_2487 nbt) {
        super.method_5652(nbt);
        nbt.method_10548("Damage", (float)this.method_7448());
        nbt.method_10548("ForcedPitch", this.method_36455());
        nbt.method_10548("ForcedYaw", this.method_36454());
        nbt.method_10569("DistanceTraveled", this.distanceTraveled);
        nbt.method_10569("TicksExisted", this.ticksExisted);
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(DAMAGE, (Object)Float.valueOf(0.0f));
        builder.method_56912(FORCED_PITCH, (Object)Float.valueOf(0.0f));
        builder.method_56912(FORCED_YAW, (Object)Float.valueOf(0.0f));
    }

    public float method_36455() {
        return ((Float)this.field_6011.method_12789(FORCED_PITCH)).floatValue();
    }

    public float method_36454() {
        return ((Float)this.field_6011.method_12789(FORCED_YAW)).floatValue();
    }

    public void method_7438(double damage) {
        this.field_6011.method_12778(DAMAGE, (Object)Float.valueOf((float)damage));
    }

    public double method_7448() {
        return ((Float)this.field_6011.method_12789(DAMAGE)).floatValue();
    }

    public float getDamageMultiplier(int distanceTraveled) {
        if (distanceTraveled < 8) {
            return class_3532.method_16439((float)((float)distanceTraveled / 8.0f), (float)0.25f, (float)1.0f);
        }
        return Math.min(2.0f, class_3532.method_16439((float)((float)(distanceTraveled - 8) / 200.0f), (float)1.0f, (float)2.0f));
    }

    private void addParticles(class_2394 particle, double x, double y, double z) {
        ALWAYS_SPAWN_PARTICLES = true;
        float range = (float)class_3532.method_16436((double)(this.method_7448() / 12.0), (double)0.0, (double)0.5);
        for (int i = 0; i < 8; ++i) {
            this.method_37908().method_8406(particle, x + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), y + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), z + (double)class_3532.method_15344((class_5819)this.field_5974, (float)(-range), (float)range), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f), (double)class_3532.method_15344((class_5819)this.field_5974, (float)-1.0f, (float)1.0f));
        }
        ALWAYS_SPAWN_PARTICLES = false;
    }

    private boolean canEntityBeHit(class_1297 owner, class_1297 entity) {
        if (entity instanceof class_1309 || entity.method_5864().method_20210(ModEntityTypeTags.BRIMSTONE_HITTABLE)) {
            return !this.hitEntities.contains(entity) && entity.method_5805() && EnchancementUtil.shouldHurt(owner, entity);
        }
        return false;
    }

    static {
        ALWAYS_SPAWN_PARTICLES = false;
        BRIMSTONE_STACK = new class_1799((class_1935)class_1802.field_8187);
        BRIMSTONE_STACK.method_57379(ModComponentTypes.BRIMSTONE_DAMAGE, (Object)Integer.MAX_VALUE);
        DAMAGE = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        FORCED_PITCH = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        FORCED_YAW = class_2945.method_12791(BrimstoneEntity.class, (class_2941)class_2943.field_13320);
        PARTICLE = new class_2390(new Vector3f(1.0f, 0.0f, 0.0f), 1.0f);
    }
}

