/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.common.Enchancement;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.payload.WallJumpPayload;
import moriyashiine.enchancement.common.payload.WallJumpSlidingPayload;
import moriyashiine.enchancement.common.tag.ModBlockTags;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3417;
import net.minecraft.class_3726;
import net.minecraft.class_4622;
import net.minecraft.class_5134;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class WallJumpComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private static final class_1322 SAFE_FALL_DISTANCE_MODIFIER = new class_1322(Enchancement.id("wall_jump_safe_fall_distance"), 8.0, class_1322.class_1323.field_6328);
    private final class_1657 obj;
    private class_2338 slidingPos = null;
    private final class_2338.class_2339 mutable = new class_2338.class_2339();
    private float jumpStrength = 0.0f;
    private boolean hasJumped = false;

    public WallJumpComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (tag.method_10545("SlidingPos")) {
            this.slidingPos = class_2338.method_10092((long)tag.method_10537("SlidingPos"));
        }
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.slidingPos != null) {
            tag.method_10544("SlidingPos", this.slidingPos.method_10063());
        }
    }

    public void tick() {
        this.jumpStrength = EnchancementUtil.getValue(ModEnchantmentEffectComponentTypes.WALL_JUMP, (class_1309)this.obj, 0.0f);
        if (this.jumpStrength == 0.0f || this.obj.method_24828()) {
            this.slidingPos = null;
            this.hasJumped = false;
        } else if (this.slidingPos != null) {
            ((class_4622)class_2246.field_21211).method_24177(this.obj.method_37908(), (class_1297)this.obj);
            ((class_4622)class_2246.field_21211).method_24180((class_1297)this.obj);
        }
    }

    public void serverTick() {
        this.tick();
        class_1324 safeFallDistanceAttribute = this.obj.method_5996(class_5134.field_49079);
        if (this.hasJumped()) {
            if (!safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER.comp_2447())) {
                safeFallDistanceAttribute.method_26837(SAFE_FALL_DISTANCE_MODIFIER);
            }
        } else if (safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER.comp_2447())) {
            safeFallDistanceAttribute.method_6202(SAFE_FALL_DISTANCE_MODIFIER);
        }
    }

    public void clientTick() {
        this.tick();
        class_2338 targetPos = null;
        if (this.jumpStrength != 0.0f) {
            if (this.obj.field_5976) {
                this.mutable.method_10102(this.obj.method_23317(), this.obj.method_23318(), this.obj.method_23321());
                for (class_2350 direction : class_2350.values()) {
                    if (!direction.method_10166().method_10179()) continue;
                    this.mutable.method_10098(direction);
                    class_2680 state = this.obj.method_37908().method_8320((class_2338)this.mutable);
                    if (!state.method_26164(ModBlockTags.UNSTICKABLE) && !state.method_26194((class_1922)this.obj.method_37908(), (class_2338)this.mutable, class_3726.method_16195((class_1297)this.obj)).method_1110() && !this.obj.method_24828() && this.obj.method_18798().method_10214() < -0.1) {
                        double mutableDistance = this.mutable.method_19770((class_2374)this.obj.method_19538());
                        if (targetPos != null && mutableDistance == targetPos.method_19770((class_2374)this.obj.method_19538())) {
                            class_2338 p1 = this.mutable.method_10093(direction.method_10170());
                            class_2338 p2 = this.mutable.method_10093(direction.method_10160());
                            targetPos = p1.method_19770((class_2374)this.obj.method_19538()) < p2.method_19770((class_2374)this.obj.method_19538()) ? p1 : p2;
                        } else if (targetPos == null || mutableDistance < targetPos.method_19770((class_2374)this.obj.method_19538())) {
                            targetPos = this.mutable.method_10062();
                        }
                    }
                    this.mutable.method_10098(direction.method_10153());
                }
            }
            if (this.slidingPos != null && this.obj.field_6282) {
                class_243 diff = this.obj.method_24515().method_46558().method_1020(this.slidingPos.method_46558()).method_1029().method_1021((double)this.jumpStrength);
                class_243 velocity = new class_243(diff.method_10216(), (double)MultiplyMovementSpeedEvent.getJumpStrength((class_1309)this.obj, this.jumpStrength * 3.0f), diff.method_10215());
                this.use(velocity);
                WallJumpPayload.send(velocity);
                targetPos = null;
            }
        }
        if (this.slidingPos != targetPos) {
            this.slidingPos = targetPos;
            WallJumpSlidingPayload.send(this.slidingPos);
        }
    }

    public boolean hasJumped() {
        return this.hasJumped;
    }

    public void setSlidingPos(class_2338 slidingPos) {
        this.slidingPos = slidingPos;
    }

    public boolean isSliding() {
        return this.slidingPos != null;
    }

    public void use(class_243 velocity) {
        this.obj.method_18799(velocity);
        this.obj.method_56078(class_3417.field_14560);
        this.slidingPos = null;
        this.hasJumped = true;
    }
}

