/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.client.EnchancementClient;
import moriyashiine.enchancement.common.Enchancement;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.payload.StartSlidingPayload;
import moriyashiine.enchancement.common.payload.StopSlidingPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1324;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_3532;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class SlideComponent
implements CommonTickingComponent {
    private static final class_1322 SAFE_FALL_DISTANCE_MODIFIER = new class_1322(Enchancement.id("slide_safe_fall_distance"), 6.0, class_1322.class_1323.field_6328);
    private static final class_1322 STEP_HEIGHT_MODIFIER = new class_1322(Enchancement.id("slide_step_height"), 1.0, class_1322.class_1323.field_6328);
    private static final int MAX_SLIDING_TICKS = 40;
    private final class_1657 obj;
    private SlideVelocity velocity = SlideVelocity.ZERO;
    private SlideVelocity adjustedVelocity = SlideVelocity.ZERO;
    private float cachedYaw = 0.0f;
    private int slidingTicks = 0;
    private float strength = 0.0f;
    private boolean hasSlide = false;
    private int crawlTimer = 0;

    public SlideComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.velocity = SlideVelocity.deserialize(tag.method_10562("Velocity"));
        this.adjustedVelocity = SlideVelocity.deserialize(tag.method_10562("AdjustedVelocity"));
        this.cachedYaw = tag.method_10583("CachedYaw");
        this.slidingTicks = tag.method_10550("SlidingTicks");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10566("Velocity", (class_2520)this.velocity.serialize());
        tag.method_10566("AdjustedVelocity", (class_2520)this.adjustedVelocity.serialize());
        tag.method_10548("CachedYaw", this.cachedYaw);
        tag.method_10569("SlidingTicks", this.slidingTicks);
    }

    public void tick() {
        boolean hasFluidWalking = EnchancementUtil.hasAnyEnchantmentsWith((class_1297)this.obj, ModEnchantmentEffectComponentTypes.FLUID_WALKING);
        this.strength = EnchancementUtil.getValue(ModEnchantmentEffectComponentTypes.SLIDE, (class_1309)this.obj, 0.0f);
        boolean bl = this.hasSlide = this.strength > 0.0f;
        if (this.crawlTimer > 0) {
            --this.crawlTimer;
        }
        if (this.hasSlide) {
            if (this.obj.method_5715() || this.obj.method_5799() && !hasFluidWalking) {
                this.stopSliding();
            }
            if (this.isSliding()) {
                if (this.updateCrawl()) {
                    this.crawlTimer = 3;
                }
                this.obj.method_5839();
                this.obj.method_37908().method_32888((class_6880)class_5712.field_28155, this.obj.method_19538(), class_5712.class_7397.method_43287((class_2680)this.obj.method_25936()));
                double dX = this.adjustedVelocity.x();
                double dZ = this.adjustedVelocity.z();
                if (!this.obj.method_24828()) {
                    dX *= 0.2;
                    dZ *= 0.2;
                }
                float multiplier = MultiplyMovementSpeedEvent.getMovementMultiplier((class_1309)this.obj);
                this.obj.method_5762(dX * (double)multiplier, 0.0, dZ * (double)multiplier);
                if (this.obj.method_5799() && hasFluidWalking) {
                    this.obj.method_18800(this.obj.method_18798().method_10216(), (double)this.strength, this.obj.method_18798().method_10215());
                }
                if (this.slidingTicks < 40) {
                    ++this.slidingTicks;
                }
            } else if (this.slidingTicks > 0) {
                this.slidingTicks = Math.max(0, this.slidingTicks - 4);
            }
        } else {
            this.stopSliding();
            this.slidingTicks = 0;
        }
    }

    public void serverTick() {
        this.tick();
        class_1324 safeFallDistanceAttribute = this.obj.method_5996(class_5134.field_49079);
        class_1324 stepHeightAttribute = this.obj.method_5996(class_5134.field_47761);
        if (this.hasSlide && this.isSliding()) {
            if (!safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER.comp_2447())) {
                safeFallDistanceAttribute.method_26837(SAFE_FALL_DISTANCE_MODIFIER);
            }
            if (!stepHeightAttribute.method_6196(STEP_HEIGHT_MODIFIER.comp_2447())) {
                stepHeightAttribute.method_26837(STEP_HEIGHT_MODIFIER);
            }
        } else {
            if (safeFallDistanceAttribute.method_6196(SAFE_FALL_DISTANCE_MODIFIER.comp_2447())) {
                safeFallDistanceAttribute.method_6202(SAFE_FALL_DISTANCE_MODIFIER);
            }
            if (stepHeightAttribute.method_6196(STEP_HEIGHT_MODIFIER.comp_2447())) {
                stepHeightAttribute.method_6202(STEP_HEIGHT_MODIFIER);
            }
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasSlide && !this.obj.method_7325() && this.obj == class_310.method_1551().field_1724) {
            class_315 options = class_310.method_1551().field_1690;
            if (EnchancementClient.SLIDE_KEYBINDING.method_1434() && !this.obj.method_5715() && !this.obj.field_6282) {
                if (this.canSlide()) {
                    this.velocity = this.getVelocityFromInput(options);
                    this.adjustedVelocity = this.velocity.rotateY((float)Math.toRadians(-(this.obj.method_36454() + 90.0f)));
                    this.cachedYaw = this.obj.method_36454();
                    StartSlidingPayload.send(this.velocity, this.adjustedVelocity, this.cachedYaw);
                }
            } else if (this.velocity != SlideVelocity.ZERO) {
                this.stopSliding();
                StopSlidingPayload.send();
            }
        }
    }

    public SlideVelocity getVelocity() {
        return this.velocity;
    }

    public float getCachedYaw() {
        return this.cachedYaw;
    }

    public void startSliding(SlideVelocity velocity, SlideVelocity adjustedVelocity, float cachedYaw) {
        this.velocity = velocity;
        this.adjustedVelocity = adjustedVelocity;
        this.cachedYaw = cachedYaw;
    }

    public void stopSliding() {
        this.startSliding(SlideVelocity.ZERO, SlideVelocity.ZERO, 0.0f);
    }

    public boolean isSliding() {
        return !this.velocity.equals(SlideVelocity.ZERO);
    }

    public float getJumpBonus() {
        return class_3532.method_16439((float)((float)this.slidingTicks / 40.0f), (float)1.0f, (float)3.0f);
    }

    public boolean hasSlide() {
        return this.hasSlide;
    }

    public boolean shouldCrawl() {
        return this.crawlTimer > 0;
    }

    public boolean canSlide() {
        return !this.isSliding() && this.obj.method_24828() && EnchancementUtil.isGroundedOrAirborne((class_1309)this.obj);
    }

    private boolean hitsBlock(class_2338 pos) {
        return !this.obj.method_37908().method_8320(pos).method_26220((class_1922)this.obj.method_37908(), pos).method_1110();
    }

    private boolean updateCrawl() {
        int height = class_3532.method_15375((float)this.obj.method_17682());
        if (height > 0) {
            class_243 frontPos = this.obj.method_19538().method_1031(0.0, (double)height, 0.0).method_1019(this.obj.method_5631(0.0f, this.cachedYaw));
            class_2338.class_2339 pos = new class_2338.class_2339(frontPos.method_10216(), frontPos.method_10214(), frontPos.method_10215());
            int y = pos.method_10264();
            boolean hitsBelow = this.hitsBlock((class_2338)pos.method_33098(y - 1));
            if (this.hitsBlock((class_2338)pos.method_33098(y))) {
                return !hitsBelow;
            }
            if (hitsBelow) {
                return this.hitsBlock((class_2338)pos.method_33098(y + 1)) || this.hitsBlock(this.obj.method_24515().method_10086(height + 1));
            }
        }
        return false;
    }

    private SlideVelocity getVelocityFromInput(class_315 options) {
        boolean any = false;
        boolean forward = false;
        boolean sideways = false;
        int x = 0;
        int z = 0;
        if (options.field_1894.method_1434()) {
            any = true;
            forward = true;
            x = 1;
        }
        if (options.field_1881.method_1434()) {
            any = true;
            forward = true;
            x = -1;
        }
        if (options.field_1913.method_1434()) {
            any = true;
            sideways = true;
            z = -1;
        }
        if (options.field_1849.method_1434()) {
            any = true;
            sideways = true;
            z = 1;
        }
        return new SlideVelocity(any ? (float)x : 1.0f, z).multiply(forward && sideways ? 0.6666667f : 1.0f).multiply(this.strength);
    }

    public record SlideVelocity(float x, float z) {
        public static final SlideVelocity ZERO = new SlideVelocity(0.0f, 0.0f);

        private static SlideVelocity deserialize(class_2487 nbt) {
            return new SlideVelocity(nbt.method_10583("VelocityX"), nbt.method_10583("VelocityZ"));
        }

        private class_2487 serialize() {
            class_2487 velocity = new class_2487();
            velocity.method_10548("VelocityX", this.x());
            velocity.method_10548("VelocityZ", this.z());
            return velocity;
        }

        SlideVelocity multiply(float value) {
            return new SlideVelocity(this.x() * value, this.z() * value);
        }

        SlideVelocity rotateY(float angle) {
            float cos = class_3532.method_15362((float)angle);
            float sin = class_3532.method_15374((float)angle);
            float nX = this.x() * cos + this.z() * sin;
            float nZ = this.z() * cos - this.x() * sin;
            return new SlideVelocity(nX, nZ);
        }
    }
}

