/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import java.util.List;
import moriyashiine.enchancement.client.payload.AddLightningDashParticlesPayload;
import moriyashiine.enchancement.client.payload.UseLightningDashPayload;
import moriyashiine.enchancement.client.sound.SparkSoundInstance;
import moriyashiine.enchancement.client.util.EnchancementClientUtil;
import moriyashiine.enchancement.common.enchantment.effect.LightningDashEffect;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.particle.SparkParticleEffect;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.minecraft.class_1113;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_238;
import net.minecraft.class_2394;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3218;
import net.minecraft.class_3417;
import net.minecraft.class_5134;
import net.minecraft.class_5712;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class LightningDashComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1309 obj;
    private boolean using = false;
    private double cachedHeight = 0.0;
    private int floatTicks = 0;
    private int smashTicks = 0;
    private boolean playedSound = false;
    private int ticksUsing = 0;
    private int hitEntityTicks = 0;

    public LightningDashComponent(class_1309 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.using = tag.method_10577("Using");
        this.floatTicks = tag.method_10550("FloatTicks");
        this.smashTicks = tag.method_10550("SmashTicks");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10556("Using", this.using);
        tag.method_10569("FloatTicks", this.floatTicks);
        tag.method_10569("SmashTicks", this.smashTicks);
    }

    public void tick() {
        int chargeTime = LightningDashEffect.getChargeTime(this.obj.method_59922(), this.obj.method_6047());
        if ((this.isFloating() || this.isSmashing()) && chargeTime == 0) {
            this.cancel();
        }
        if (this.isFloating()) {
            --this.floatTicks;
            this.obj.field_6017 = 0.0f;
            this.obj.method_18799(this.obj.method_18798().method_1021(0.9));
            if (this.obj.field_6252 && this.obj.method_36455() > -15.0f) {
                this.cachedHeight = this.obj.method_23318();
                this.smashTicks = 30;
                this.floatTicks = 0;
                this.obj.method_18799(this.obj.method_5720().method_1021((double)LightningDashEffect.getSmashStrength(this.obj.method_59922(), this.obj.method_6047())));
                this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_ZAP, 2.0f, 1.0f);
            }
        }
        if (this.isSmashing()) {
            --this.smashTicks;
            if (!this.getNearby(3).isEmpty()) {
                this.hitEntityTicks = 2;
            }
            if (this.obj.method_24828()) {
                if (this.smashTicks > 1) {
                    this.smashTicks = 1;
                }
                if (this.smashTicks == 1) {
                    this.obj.method_5783(class_3417.field_49924, 1.0f, 1.0f);
                    this.obj.method_37908().method_32888((class_6880)class_5712.field_28155, this.obj.method_19538(), class_5712.class_7397.method_43287((class_2680)this.obj.method_25936()));
                } else {
                    this.obj.field_6017 = 0.0f;
                }
            }
        }
        if (chargeTime > 0 && this.obj.method_6115()) {
            if (!this.playedSound && this.obj.method_6048() == chargeTime) {
                this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_PING, 1.0f, 1.0f);
                this.playedSound = true;
            }
            if (this.ticksUsing % 18 == 0) {
                this.obj.method_5783(ModSoundEvents.ITEM_GENERIC_WHOOSH, 0.5f, 1.0f);
            }
            ++this.ticksUsing;
        } else {
            this.playedSound = false;
            this.ticksUsing = 0;
        }
        if (this.hitEntityTicks > 0) {
            --this.hitEntityTicks;
        }
    }

    public void serverTick() {
        this.tick();
        if (this.isFloating() && !EnchancementUtil.isSufficientlyHigh((class_1297)this.obj, 0.25)) {
            this.cancel();
            this.sync();
        }
        if (this.smashTicks == 1 && this.obj.method_24828()) {
            PlayerLookup.tracking((class_1297)this.obj).forEach(foundPlayer -> AddLightningDashParticlesPayload.send(foundPlayer, this.obj.method_5628()));
            this.obj.field_6017 = (float)Math.max(0.0, this.cachedHeight - this.obj.method_23318());
            float base = (float)this.obj.method_45325(class_5134.field_23721);
            this.getNearby(1).forEach(entity -> {
                class_1282 class_12822;
                class_1309 patt0$temp = this.obj;
                if (patt0$temp instanceof class_1657) {
                    class_1657 player = (class_1657)patt0$temp;
                    class_12822 = entity.method_48923().method_48802(player);
                } else {
                    class_12822 = entity.method_48923().method_48812(this.obj);
                }
                class_1282 source = class_12822;
                float damage = class_1890.method_60120((class_3218)((class_3218)this.obj.method_37908()), (class_1799)this.obj.method_6047(), (class_1297)entity, (class_1282)source, (float)base) + this.obj.method_6047().method_7909().method_58403((class_1297)entity, base, source);
                if (entity.method_5643(source, damage * LightningDashEffect.getSmashDamageMultiplier(this.obj.method_59922(), this.obj.method_6047()))) {
                    entity.method_6005(1.5, this.obj.method_23317() - entity.method_23317(), this.obj.method_23321() - entity.method_23321());
                }
            });
        }
    }

    public void clientTick() {
        this.tick();
        if (this.isFloating() && EnchancementClientUtil.shouldAddParticles((class_1297)this.obj)) {
            for (int i = 0; i <= 4; ++i) {
                this.obj.method_37908().method_8406((class_2394)new SparkParticleEffect(this.obj.method_19538().method_49272(this.obj.method_59922(), 1.0f)), this.obj.method_23322(1.0), this.obj.method_23319(), this.obj.method_23325(1.0), 0.0, 0.0, 0.0);
            }
        }
        if (this.smashTicks == 1 && this.obj.method_24828()) {
            AddLightningDashParticlesPayload.addParticles((class_1297)this.obj);
        }
    }

    public void sync() {
        ModEntityComponents.LIGHTNING_DASH.sync((Object)this.obj);
    }

    public void setUsing(boolean using) {
        this.using = using;
    }

    public boolean isUsing() {
        return this.using;
    }

    public void useCommon(class_243 lungeVelocity, int floatTicks) {
        this.obj.method_18799(lungeVelocity);
        this.floatTicks = floatTicks;
    }

    @Environment(value=EnvType.CLIENT)
    public void useClient() {
        class_310.method_1551().method_1483().method_4873((class_1113)new SparkSoundInstance((class_1297)this.obj));
    }

    public void useServer(class_243 lungeVelocity, int floatTicks) {
        PlayerLookup.tracking((class_1297)this.obj).forEach(foundPlayer -> UseLightningDashPayload.send(foundPlayer, this.obj.method_5628(), lungeVelocity, floatTicks));
    }

    public boolean isFloating() {
        return this.floatTicks > 0;
    }

    private boolean isSmashing() {
        return this.smashTicks > 0;
    }

    public boolean hitNoEntity() {
        return this.hitEntityTicks == 0;
    }

    public void cancel() {
        this.smashTicks = 0;
        this.floatTicks = 0;
    }

    private List<class_1309> getNearby(int range) {
        return this.obj.method_37908().method_8390(class_1309.class, new class_238(this.obj.method_24515()).method_1009(2.0, (double)range, 2.0), foundEntity -> foundEntity.method_5805() && foundEntity.method_5739((class_1297)this.obj) < 10.0f && EnchancementUtil.shouldHurt((class_1297)this.obj, (class_1297)foundEntity) && EnchancementUtil.canSee((class_1297)this.obj, (class_1297)foundEntity, range));
    }
}

