/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import java.util.Collections;
import moriyashiine.enchancement.client.util.EnchancementClientUtil;
import moriyashiine.enchancement.common.enchantment.effect.LeechingTridentEffect;
import moriyashiine.enchancement.common.init.ModDamageTypes;
import moriyashiine.enchancement.common.init.ModEnchantmentEffectComponentTypes;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_1685;
import net.minecraft.class_1799;
import net.minecraft.class_1890;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.apache.commons.lang3.mutable.MutableFloat;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class LeechingTridentComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1685 obj;
    private LeechData leechData = null;
    private class_1309 stuckEntity = null;
    private int stuckEntityId = -1;
    private int leechingTicks = 0;
    private int stabTicks = 0;

    public LeechingTridentComponent(class_1685 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (tag.method_10545("LeechData")) {
            this.leechData = LeechData.deserialize(tag.method_10562("LeechData"));
        }
        this.stuckEntityId = tag.method_10550("StuckEntityId");
        this.leechingTicks = tag.method_10550("LeechingTicks");
        this.stabTicks = tag.method_10550("StabTicks");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        if (this.leechData != null) {
            tag.method_10566("LeechData", (class_2520)this.leechData.serialize());
        }
        tag.method_10569("StuckEntityId", this.stuckEntityId);
        tag.method_10569("LeechingTicks", this.leechingTicks);
        tag.method_10569("StabTicks", this.stabTicks);
    }

    public void tick() {
        class_1297 class_12972;
        if (this.stuckEntityId == -2) {
            this.stuckEntity = null;
            this.stuckEntityId = -1;
        } else if (this.stuckEntityId != -1 && this.stuckEntity == null && (class_12972 = this.obj.method_37908().method_8469(this.stuckEntityId)) instanceof class_1309) {
            class_1309 living;
            this.stuckEntity = living = (class_1309)class_12972;
        } else if (this.stuckEntity != null && this.stuckEntity.method_5805()) {
            this.obj.method_18799(class_243.field_1353);
            if (++this.leechingTicks > this.leechData.maxTicks()) {
                this.stuckEntityId = -2;
            }
            if (this.stabTicks > 0) {
                --this.stabTicks;
            }
        } else {
            this.stuckEntityId = -2;
            this.leechingTicks = 0;
            this.stabTicks = 0;
        }
    }

    public void serverTick() {
        this.tick();
        if (this.stuckEntity != null && this.stuckEntity.method_5805()) {
            class_1309 living;
            class_1297 class_12972 = this.obj.method_24921();
            if (class_12972 instanceof class_1309 && (living = (class_1309)class_12972).method_5805()) {
                this.obj.method_24203(this.stuckEntity.method_23317(), this.stuckEntity.method_23320(), this.stuckEntity.method_23321());
                if (this.leechingTicks % 20 == 0 && this.stuckEntity.method_5643(ModDamageTypes.create(this.obj.method_37908(), ModDamageTypes.LIFE_DRAIN, (class_1297)this.obj, (class_1297)living), this.leechData.damage())) {
                    living.method_6025(this.leechData.healAmount());
                    this.stuckEntity.field_6008 = 0;
                    this.stabTicks = 20;
                    this.sync();
                }
            } else {
                this.stuckEntityId = -2;
                this.sync();
            }
        }
    }

    public void clientTick() {
        this.tick();
        if (this.stuckEntity != null && this.stuckEntity.method_5805() && this.stabTicks == 19 && EnchancementClientUtil.shouldAddParticles((class_1297)this.stuckEntity)) {
            for (int i = 0; i < 5; ++i) {
                this.obj.method_37908().method_8406((class_2394)class_2398.field_11209, this.stuckEntity.method_23322(0.5), this.stuckEntity.method_23323(0.5), this.stuckEntity.method_23325(0.5), 0.0, 0.0, 0.0);
            }
        }
    }

    public void sync() {
        ModEntityComponents.LEECHING_TRIDENT.sync((Object)this.obj);
    }

    public boolean hasLeech() {
        return this.leechData != null;
    }

    public class_1309 getStuckEntity() {
        return this.stuckEntity;
    }

    public void setStuckEntityId(int stuckEntityId) {
        this.stuckEntityId = stuckEntityId;
    }

    public int getLeechingTicks() {
        return this.leechingTicks;
    }

    public float getStabTicks() {
        return this.stabTicks;
    }

    public static void maybeSet(class_1309 user, class_1799 stack, class_1297 entity) {
        if (entity instanceof class_1685) {
            MutableFloat damage = new MutableFloat();
            MutableFloat healAmount = new MutableFloat();
            MutableFloat duration = new MutableFloat();
            if (class_1890.method_60142((class_1799)stack, ModEnchantmentEffectComponentTypes.LEECHING_TRIDENT)) {
                LeechingTridentEffect.setValues(user.method_59922(), damage, healAmount, duration, Collections.singleton(stack));
            } else if (!(user instanceof class_1657) && EnchancementUtil.hasAnyEnchantmentsWith((class_1297)user, ModEnchantmentEffectComponentTypes.LEECHING_TRIDENT)) {
                LeechingTridentEffect.setValues(user.method_59922(), damage, healAmount, duration, user.method_56675());
            }
            if (damage.floatValue() != 0.0f) {
                LeechingTridentComponent leechingTridentComponent = (LeechingTridentComponent)ModEntityComponents.LEECHING_TRIDENT.get((Object)entity);
                leechingTridentComponent.leechData = new LeechData(damage.floatValue(), healAmount.floatValue(), class_3532.method_15375((float)(duration.floatValue() * 20.0f)));
                leechingTridentComponent.sync();
            }
        }
    }

    public record LeechData(float damage, float healAmount, int maxTicks) {
        static LeechData deserialize(class_2487 nbt) {
            return new LeechData(nbt.method_10583("Damage"), nbt.method_10583("HealAmount"), nbt.method_10550("MaxTicks"));
        }

        class_2487 serialize() {
            class_2487 nbt = new class_2487();
            nbt.method_10548("Damage", this.damage());
            nbt.method_10548("HealAmount", this.healAmount());
            nbt.method_10569("MaxTicks", this.maxTicks());
            return nbt;
        }
    }
}

