/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.client.EnchancementClient;
import moriyashiine.enchancement.client.payload.AddMovementBurstParticlesPayload;
import moriyashiine.enchancement.common.ModConfig;
import moriyashiine.enchancement.common.component.entity.AirMobilityComponent;
import moriyashiine.enchancement.common.enchantment.effect.DirectionBurstEffect;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.DirectionBurstPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_310;
import net.minecraft.class_315;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class DirectionBurstComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 obj;
    private boolean shouldRefresh = false;
    private int cooldown = 0;
    private int lastCooldown = 0;
    private int gravityTicks = 0;
    private boolean hasDirectionBurst = false;
    private boolean wasPressingKey = false;
    private int ticksLeftToPressActivationKey = 0;

    public DirectionBurstComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.shouldRefresh = tag.method_10577("ShouldRefresh");
        this.cooldown = tag.method_10550("Cooldown");
        this.lastCooldown = tag.method_10550("LastCooldown");
        this.gravityTicks = tag.method_10550("GravityTicks");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10556("ShouldRefresh", this.shouldRefresh);
        tag.method_10569("Cooldown", this.cooldown);
        tag.method_10569("LastCooldown", this.lastCooldown);
        tag.method_10569("GravityTicks", this.gravityTicks);
    }

    public void tick() {
        int entityCooldown = DirectionBurstEffect.getCooldown((class_1309)this.obj);
        boolean bl = this.hasDirectionBurst = entityCooldown > 0;
        if (this.hasDirectionBurst) {
            if (!this.shouldRefresh) {
                if (this.obj.method_24828()) {
                    this.shouldRefresh = true;
                }
            } else if (this.cooldown > 0) {
                --this.cooldown;
            }
            if (this.gravityTicks > 0) {
                --this.gravityTicks;
            }
        } else {
            this.shouldRefresh = false;
            this.setCooldown(0);
            this.gravityTicks = 0;
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasDirectionBurst && this.canUse() && this.obj == class_310.method_1551().field_1724) {
            class_315 options = class_310.method_1551().field_1690;
            boolean pressingKey = EnchancementClient.DIRECTION_BURST_KEYBINDING.method_1434();
            if (this.ticksLeftToPressActivationKey > 0) {
                --this.ticksLeftToPressActivationKey;
            }
            if (pressingKey && !this.wasPressingKey) {
                if (!ModConfig.doublePressDirectionBurst || this.ticksLeftToPressActivationKey > 0) {
                    this.ticksLeftToPressActivationKey = 0;
                    class_243 inputVelocity = this.getVelocityFromInput(options);
                    if (inputVelocity != class_243.field_1353) {
                        class_243 velocity = inputVelocity.method_1024((float)Math.toRadians(-(this.obj.method_5791() + 90.0f))).method_1021((double)MultiplyMovementSpeedEvent.getMovementMultiplier((class_1309)this.obj));
                        this.use(velocity.method_10216(), velocity.method_10215());
                        AddMovementBurstParticlesPayload.addParticles((class_1297)this.obj);
                        DirectionBurstPayload.send(velocity);
                    }
                } else {
                    this.ticksLeftToPressActivationKey = 7;
                }
            }
            this.wasPressingKey = pressingKey;
        }
    }

    public void sync() {
        ModEntityComponents.DIRECTION_BURST.sync((Object)this.obj);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    private void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.lastCooldown = cooldown;
    }

    public int getLastCooldown() {
        return this.lastCooldown;
    }

    public boolean hasDirectionBurst() {
        return this.hasDirectionBurst;
    }

    public boolean canUse() {
        return this.cooldown == 0 && EnchancementUtil.isGroundedOrAirborne((class_1309)this.obj);
    }

    public boolean preventFalling() {
        return this.gravityTicks > 0;
    }

    public void use(double velocityX, double velocityZ) {
        this.reset();
        this.gravityTicks = 3;
        this.obj.method_18800(velocityX, 0.0, velocityZ);
        this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_STRAFE, 1.0f, 1.0f);
        this.obj.field_6017 = 0.0f;
        ((AirMobilityComponent)ModEntityComponents.AIR_MOBILITY.get((Object)this.obj)).resetTicksInAir();
    }

    public void reset() {
        this.setCooldown(DirectionBurstEffect.getCooldown((class_1309)this.obj));
        this.shouldRefresh = false;
    }

    @Environment(value=EnvType.CLIENT)
    private class_243 getVelocityFromInput(class_315 options) {
        float strength = this.obj.method_24828() ? DirectionBurstEffect.getGroundStrength((class_1309)this.obj) : DirectionBurstEffect.getAirStrength((class_1309)this.obj);
        class_243 velocity = class_243.field_1353;
        if (options.field_1894.method_1434()) {
            velocity = new class_243((double)strength, 0.0, 0.0);
        }
        if (options.field_1881.method_1434()) {
            velocity = new class_243((double)(-strength), 0.0, 0.0);
        }
        if (options.field_1913.method_1434()) {
            velocity = new class_243(0.0, 0.0, (double)(-strength));
        }
        if (options.field_1849.method_1434()) {
            velocity = new class_243(0.0, 0.0, (double)strength);
        }
        if (ModConfig.inputlessDirectionBurst && !this.obj.method_24828() && velocity.equals((Object)class_243.field_1353)) {
            velocity = new class_243((double)strength, 0.0, 0.0);
        }
        return velocity;
    }
}

