/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import java.util.ArrayList;
import java.util.List;
import moriyashiine.enchancement.common.enchantment.effect.entity.ConditionalAttributeEnchantmentEffect;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_47;
import net.minecraft.class_5341;
import net.minecraft.class_6880;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.tick.ServerTickingComponent;

public class ConditionalAttributesComponent
implements ServerTickingComponent {
    private final class_1309 obj;
    private final List<ConditionalAttribute> attributes = new ArrayList<ConditionalAttribute>();
    private boolean removeAll = false;

    public ConditionalAttributesComponent(class_1309 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.attributes.clear();
        class_2499 list = tag.method_10554("Attributes", 10);
        for (int i = 0; i < list.size(); ++i) {
            class_2487 attributeCompound = list.method_10602(i);
            ConditionalAttribute.CODEC.parse((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)attributeCompound).ifSuccess(this.attributes::add);
        }
        this.removeAll = tag.method_10577("RemoveAll");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        class_2499 attributes = new class_2499();
        for (ConditionalAttribute attribute : this.attributes) {
            ConditionalAttribute.CODEC.encodeStart((DynamicOps)registryLookup.method_57093((DynamicOps)class_2509.field_11560), (Object)attribute).ifSuccess(arg_0 -> attributes.add(arg_0));
        }
        tag.method_10566("Attributes", (class_2520)attributes);
        tag.method_10556("RemoveAll", this.removeAll);
    }

    public void serverTick() {
        class_47 ctx = ConditionalAttributeEnchantmentEffect.createContext(this.obj);
        this.attributes.removeIf(attribute -> {
            if (!this.removeAll && attribute.condition().test((Object)ctx)) {
                return false;
            }
            this.obj.method_5996(attribute.attribute()).method_6200(attribute.id());
            return true;
        });
        this.removeAll = false;
    }

    public void addAttribute(class_6880<class_1320> attribute, class_2960 id, class_5341 condition) {
        this.attributes.add(new ConditionalAttribute(attribute, id, condition));
    }

    public void markRemoved() {
        this.removeAll = true;
    }

    public record ConditionalAttribute(class_6880<class_1320> attribute, class_2960 id, class_5341 condition) {
        static final Codec<ConditionalAttribute> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_1320.field_51575.fieldOf("attribute").forGetter(ConditionalAttribute::attribute), (App)class_2960.field_25139.fieldOf("id").forGetter(ConditionalAttribute::id), (App)class_5341.field_51809.fieldOf("condition").forGetter(ConditionalAttribute::condition)).apply((Applicative)instance, ConditionalAttribute::new));
    }
}

