/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.common.component.entity;

import moriyashiine.enchancement.api.event.MultiplyMovementSpeedEvent;
import moriyashiine.enchancement.client.payload.AddAirJumpParticlesPayload;
import moriyashiine.enchancement.common.component.entity.WallJumpComponent;
import moriyashiine.enchancement.common.enchantment.effect.AirJumpEffect;
import moriyashiine.enchancement.common.init.ModEntityComponents;
import moriyashiine.enchancement.common.init.ModSoundEvents;
import moriyashiine.enchancement.common.payload.AirJumpPayload;
import moriyashiine.enchancement.common.util.EnchancementUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1657;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_3532;
import net.minecraft.class_7225;
import org.ladysnake.cca.api.v3.component.sync.AutoSyncedComponent;
import org.ladysnake.cca.api.v3.component.tick.CommonTickingComponent;

public class AirJumpComponent
implements AutoSyncedComponent,
CommonTickingComponent {
    private final class_1657 obj;
    private boolean shouldRefresh = false;
    private int cooldown = 0;
    private int lastCooldown = 0;
    private int jumpCooldown = 10;
    private int jumpsLeft = 0;
    private int ticksInAir = 0;
    private int maxJumps = 0;
    private boolean hasAirJump = false;

    public AirJumpComponent(class_1657 obj) {
        this.obj = obj;
    }

    public void readFromNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        this.shouldRefresh = tag.method_10577("ShouldRefresh");
        this.cooldown = tag.method_10550("Cooldown");
        this.lastCooldown = tag.method_10550("LastCooldown");
        this.jumpCooldown = tag.method_10550("JumpCooldown");
        this.jumpsLeft = tag.method_10550("JumpsLeft");
        this.ticksInAir = tag.method_10550("TicksInAir");
    }

    public void writeToNbt(class_2487 tag, class_7225.class_7874 registryLookup) {
        tag.method_10556("ShouldRefresh", this.shouldRefresh);
        tag.method_10569("Cooldown", this.cooldown);
        tag.method_10569("LastCooldown", this.lastCooldown);
        tag.method_10569("JumpCooldown", this.jumpCooldown);
        tag.method_10569("JumpsLeft", this.jumpsLeft);
        tag.method_10569("TicksInAir", this.ticksInAir);
    }

    public void tick() {
        int entityCooldown = AirJumpEffect.getChargeCooldown((class_1309)this.obj);
        this.maxJumps = AirJumpEffect.getAirJumps((class_1309)this.obj);
        boolean bl = this.hasAirJump = this.maxJumps > 0;
        if (this.hasAirJump) {
            if (!this.shouldRefresh) {
                if (this.obj.method_24828()) {
                    this.shouldRefresh = true;
                }
            } else if (this.cooldown > 0) {
                --this.cooldown;
                if (this.cooldown == 0 && this.jumpsLeft < this.maxJumps) {
                    ++this.jumpsLeft;
                    this.setCooldown(entityCooldown);
                }
            }
            if (this.jumpCooldown > 0) {
                --this.jumpCooldown;
            }
            this.ticksInAir = this.obj.method_24828() ? 0 : ++this.ticksInAir;
        } else {
            this.shouldRefresh = false;
            this.setCooldown(0);
            this.jumpCooldown = 0;
            this.jumpsLeft = 0;
            this.ticksInAir = 0;
        }
        if (((WallJumpComponent)ModEntityComponents.WALL_JUMP.get((Object)this.obj)).isSliding()) {
            this.jumpCooldown = AirJumpEffect.getJumpCooldown((class_1309)this.obj);
        }
    }

    public void clientTick() {
        this.tick();
        if (this.hasAirJump && this.obj.field_6282 && this.canUse()) {
            this.use();
            AddAirJumpParticlesPayload.addParticles((class_1297)this.obj);
            AirJumpPayload.send();
        }
    }

    public void sync() {
        ModEntityComponents.AIR_JUMP.sync((Object)this.obj);
    }

    public int getCooldown() {
        return this.cooldown;
    }

    private void setCooldown(int cooldown) {
        this.cooldown = cooldown;
        this.lastCooldown = cooldown;
    }

    public int getLastCooldown() {
        return this.lastCooldown;
    }

    public int getJumpsLeft() {
        return this.jumpsLeft;
    }

    public int getMaxJumps() {
        return this.maxJumps;
    }

    public boolean hasAirJump() {
        return this.hasAirJump;
    }

    public boolean canUse() {
        int entityJumpCooldown = AirJumpEffect.getJumpCooldown((class_1309)this.obj);
        return this.jumpCooldown == 0 && this.jumpsLeft > 0 && this.ticksInAir >= (this.obj.method_37908().field_9236 ? entityJumpCooldown : entityJumpCooldown - 1) && !this.obj.method_24828() && EnchancementUtil.isGroundedOrAirborne((class_1309)this.obj);
    }

    public void use() {
        this.obj.method_18800(this.obj.method_18798().method_10216(), (double)MultiplyMovementSpeedEvent.getJumpStrength((class_1309)this.obj, AirJumpEffect.getAirJumpStrength((class_1309)this.obj)), this.obj.method_18798().method_10215());
        if (this.obj.method_5624()) {
            float rad = (float)Math.toRadians(this.obj.method_36454());
            this.obj.method_45319(new class_243((double)(-class_3532.method_15374((float)rad)) * 0.2, 0.0, (double)class_3532.method_15362((float)rad) * 0.2));
        }
        this.obj.field_6007 = true;
        this.obj.method_5783(ModSoundEvents.ENTITY_GENERIC_AIR_JUMP, 1.0f, 1.0f);
        if (this.cooldown == 0 || this.jumpsLeft == this.maxJumps) {
            this.setCooldown(AirJumpEffect.getChargeCooldown((class_1309)this.obj));
        }
        this.shouldRefresh = false;
        this.jumpCooldown = AirJumpEffect.getJumpCooldown((class_1309)this.obj);
        --this.jumpsLeft;
    }

    public void reset() {
        this.setCooldown(AirJumpEffect.getChargeCooldown((class_1309)this.obj));
        this.jumpsLeft = 0;
    }
}

