/*
 * Decompiled with CFR 0.152.
 */
package moriyashiine.enchancement.client.particle;

import java.util.ArrayList;
import java.util.List;
import moriyashiine.enchancement.common.particle.SparkParticleEffect;
import net.minecraft.class_1921;
import net.minecraft.class_243;
import net.minecraft.class_310;
import net.minecraft.class_3999;
import net.minecraft.class_4184;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_638;
import net.minecraft.class_703;
import net.minecraft.class_707;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Vector3f;

public class SparkParticle
extends class_703 {
    private final class_243 destination;
    private final List<class_243> arcs = new ArrayList<class_243>();

    protected SparkParticle(class_638 world, double x, double y, double z, class_243 destination) {
        super(world, x, y, z);
        this.destination = destination;
        this.field_3847 = 5;
        this.randomizeArcs();
        this.field_3861 = 0.2f;
        this.field_3842 = 0.7f;
        this.field_3859 = 0.3f;
    }

    public class_3999 method_18122() {
        return class_3999.field_17831;
    }

    public void method_3070() {
        super.method_3070();
        if (this.field_3851.method_8409().method_43048(5) == 0) {
            this.randomizeArcs();
        }
    }

    public void method_3074(class_4588 vertexConsumer, class_4184 camera, float tickDelta) {
        class_4587 matrixStack = new class_4587();
        vertexConsumer = class_310.method_1551().method_22940().method_23000().getBuffer(class_1921.method_23593());
        class_243 cameraPos = camera.method_19326();
        for (int i = 1; i < this.arcs.size(); ++i) {
            class_243 start = this.arcs.get(i - 1);
            class_243 end = this.arcs.get(i);
            float startX = (float)(start.method_10216() - cameraPos.method_10216());
            float startY = (float)(start.method_10214() - cameraPos.method_10214());
            float startZ = (float)(start.method_10215() - cameraPos.method_10215());
            float endX = (float)(end.method_10216() - cameraPos.method_10216());
            float endY = (float)(end.method_10214() - cameraPos.method_10214());
            float endZ = (float)(end.method_10215() - cameraPos.method_10215());
            Vector3f normal = new Vector3f(endX - startX, endY - startY, endZ - startZ).normalize();
            Vector3f verticalOffset = normal.cross(normal.x(), normal.y(), 0.0f, new Vector3f()).normalize().mul(0.025f);
            Vector3f horizontalOffset = normal.cross(normal.x(), 0.0f, normal.z(), new Vector3f()).normalize().mul(0.025f);
            Matrix4f position = matrixStack.method_23760().method_23761();
            this.drawFace(vertexConsumer, position, startX + verticalOffset.x(), startY + verticalOffset.y(), startZ + verticalOffset.z(), endX + verticalOffset.x(), endY + verticalOffset.y(), endZ + verticalOffset.z(), endX + horizontalOffset.x(), endY + horizontalOffset.y(), endZ + horizontalOffset.z(), startX + horizontalOffset.x(), startY + horizontalOffset.y(), startZ + horizontalOffset.z());
            this.drawFace(vertexConsumer, position, startX + horizontalOffset.x(), startY + horizontalOffset.y(), startZ + horizontalOffset.z(), endX + horizontalOffset.x(), endY + horizontalOffset.y(), endZ + horizontalOffset.z(), endX - verticalOffset.x(), endY - verticalOffset.y(), endZ - verticalOffset.z(), startX - verticalOffset.x(), startY - verticalOffset.y(), startZ - verticalOffset.z());
            this.drawFace(vertexConsumer, position, startX - verticalOffset.x(), startY - verticalOffset.y(), startZ - verticalOffset.z(), endX - verticalOffset.x(), endY - verticalOffset.y(), endZ - verticalOffset.z(), endX - horizontalOffset.x(), endY - horizontalOffset.y(), endZ - horizontalOffset.z(), startX - horizontalOffset.x(), startY - horizontalOffset.y(), startZ - horizontalOffset.z());
            this.drawFace(vertexConsumer, position, startX - horizontalOffset.x(), startY - horizontalOffset.y(), startZ - horizontalOffset.z(), endX - horizontalOffset.x(), endY - horizontalOffset.y(), endZ - horizontalOffset.z(), endX + verticalOffset.x(), endY + verticalOffset.y(), endZ + verticalOffset.z(), startX + verticalOffset.x(), startY + verticalOffset.y(), startZ + verticalOffset.z());
        }
    }

    private void drawFace(class_4588 consumer, Matrix4f matrix4f, float x1, float y1, float z1, float x2, float y2, float z2, float x3, float y3, float z3, float x4, float y4, float z4) {
        consumer.method_22918(matrix4f, x1, y1, z1).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        consumer.method_22918(matrix4f, x2, y2, z2).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        consumer.method_22918(matrix4f, x3, y3, z3).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        consumer.method_22918(matrix4f, x4, y4, z4).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        consumer.method_22918(matrix4f, x1, y1, z1).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        consumer.method_22918(matrix4f, x4, y4, z4).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        consumer.method_22918(matrix4f, x3, y3, z3).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
        consumer.method_22918(matrix4f, x2, y2, z2).method_22915(this.field_3861, this.field_3842, this.field_3859, this.field_3841);
    }

    private void randomizeArcs() {
        this.arcs.clear();
        double length = Math.sqrt(this.destination.method_1028(this.field_3874, this.field_3854, this.field_3871));
        double arcCount = length / 0.5;
        class_243 normal = this.destination.method_1023(this.field_3874, this.field_3854, this.field_3871).method_1029();
        int i = 0;
        while ((double)i < arcCount) {
            this.arcs.add(normal.method_1021(length * ((double)i / arcCount)).method_1031(this.field_3874, this.field_3854, this.field_3871).method_49272(this.field_3851.method_8409(), 0.5f));
            ++i;
        }
        this.arcs.add(this.destination);
    }

    public static class Factory
    implements class_707<SparkParticleEffect> {
        @Nullable
        public class_703 createParticle(SparkParticleEffect parameters, class_638 world, double x, double y, double z, double velocityX, double velocityY, double velocityZ) {
            return new SparkParticle(world, x, y, z, parameters.destination());
        }
    }
}

