
uniform sampler2D DiffuseSampler0;

in vec2 texCoord;

out vec4 fragColor;
uniform int shouldRender;

void main() {
    // Sample from the screen

    vec4 baseColor = texture(DiffuseSampler0, texCoord);
    if (shouldRender == 2) {
        float f = (baseColor.r+baseColor.g)/2.0f;
        if (baseColor.b > f) {
            fragColor = vec4(f, f, baseColor.b, baseColor.a);
        } else {
            fragColor = vec4(f, f, f, baseColor.a);
        }
    }
    if (shouldRender == 1) {
        float f = (baseColor.r+baseColor.g+baseColor.b)/2.0f;
        fragColor = vec4(f, f, f, baseColor.a);
    }
    if (shouldRender == 0) {
        fragColor = baseColor;
    }
}