/*
 * Decompiled with CFR 0.152.
 */
package org.agmas.holo.state;

import com.mojang.authlib.GameProfile;
import com.mojang.serialization.Codec;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import java.util.concurrent.atomic.AtomicInteger;
import net.fabricmc.fabric.api.attachment.v1.AttachmentRegistry;
import net.fabricmc.fabric.api.attachment.v1.AttachmentType;
import net.fabricmc.loader.impl.util.log.Log;
import net.fabricmc.loader.impl.util.log.LogCategory;
import net.minecraft.class_1309;
import net.minecraft.class_2487;
import net.minecraft.class_2520;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_7924;
import net.minecraft.server.MinecraftServer;
import org.agmas.holo.Holo;
import org.agmas.holo.util.FakestPlayer;
import org.agmas.holo.util.HoloModifiers;
import org.agmas.holo.util.HologramType;

public class HoloNbtManager {
    public HashMap<UUID, PlayerData> players = new HashMap();
    public static final AttachmentType<class_2487> holoData = AttachmentRegistry.createPersistent((class_2960)class_2960.method_60655((String)"holo", (String)"holodata"), (Codec)class_2487.field_25128);
    public static HoloNbtManager INSTANCE;

    public static void init() {
    }

    public static PlayerData getPlayerState(class_1309 player) {
        HoloNbtManager serverState = HoloNbtManager.getServerState(player.method_37908().method_8503());
        return serverState.players.computeIfAbsent(player.method_5667(), uuid -> new PlayerData());
    }

    public static HoloNbtManager createFromNbt(class_2487 tag, MinecraftServer server) {
        HoloNbtManager state = new HoloNbtManager();
        class_2487 playersNbt = tag.method_10562("players");
        playersNbt.method_10541().forEach(key -> {
            PlayerData playerData = new PlayerData();
            playerData.inHoloMode = playersNbt.method_10562(key).method_10577("inHoloMode");
            playerData.loreAccurate = playersNbt.method_10562(key).method_10577("loreMode");
            playerData.cloneCompound = playersNbt.method_10562(key).method_10562("clones");
            if (playersNbt.method_10562(key).method_10573("holoName", 8)) {
                playerData.holoName = playersNbt.method_10562(key).method_10558("holoName");
            }
            if (playersNbt.method_10562(key).method_10573("type", 3)) {
                playerData.hologramType = HologramType.values()[playersNbt.method_10562(key).method_10550("type")];
            }
            if (playersNbt.method_10562(key).method_10573("totalHolosCreated", 3)) {
                playerData.totalHolosCreated = playersNbt.method_10562(key).method_10550("totalHolosCreated");
            }
            if (playersNbt.method_10562(key).method_10573("lastComputerMaxPower", 3)) {
                playerData.lastComputerMaxPower = playersNbt.method_10562(key).method_10550("lastComputerMaxPower");
            }
            Log.info((LogCategory)LogCategory.GENERAL, (String)String.valueOf(playerData.cloneCompound));
            if (playerData.cloneCompound != null) {
                AtomicInteger i = new AtomicInteger();
                playerData.cloneCompound.method_10541().forEach(k -> {
                    String ids = playerData.cloneCompound.method_10562(k).method_10558("Dimension");
                    class_2960 id = class_2960.method_60654((String)ids);
                    FakestPlayer fakePlayer = FakestPlayer.get(Holo.server.method_3847(class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id)), new GameProfile(Holo.getFreeUUID(), ""), playerData.cloneCompound.method_10562(k).method_10558("ownerName"), UUID.fromString(key));
                    fakePlayer.worldName = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)id);
                    fakePlayer.method_5749(playerData.cloneCompound.method_10562(k));
                    fakePlayer.isHologram = playerData.cloneCompound.method_10562(k).method_10577("isHologram");
                    fakePlayer.type = playerData.cloneCompound.method_10562(k).method_10573("type", 3) ? HologramType.values()[playerData.cloneCompound.method_10562(k).method_10550("type")] : HologramType.NORMAL;
                    if (playerData.cloneCompound.method_10562(k).method_10573("HoloName", 8)) {
                        Log.info((LogCategory)LogCategory.GENERAL, (String)playerData.cloneCompound.method_10562(k).method_10558("HoloName"));
                        fakePlayer.holoName = playerData.cloneCompound.method_10562(k).method_10558("HoloName");
                    } else {
                        fakePlayer.holoName = "h" + i.get();
                    }
                    i.getAndIncrement();
                    playerData.clones.add(fakePlayer);
                });
            }
            UUID uuid = UUID.fromString(key);
            state.players.put(uuid, playerData);
        });
        return state;
    }

    public static HoloNbtManager getServerState(MinecraftServer server) {
        return INSTANCE;
    }

    public class_2487 writeNbt(class_2487 nbt) {
        class_2487 holoNbt = new class_2487();
        this.players.forEach((uuid, playerData) -> {
            class_2487 playerNbt = new class_2487();
            class_2487 cloneNbt = new class_2487();
            playerNbt.method_10556("inHoloMode", playerData.inHoloMode);
            playerNbt.method_10556("loreMode", playerData.loreAccurate);
            playerNbt.method_10582("playerName", playerData.playerName);
            playerNbt.method_10582("holoName", playerData.holoName);
            playerNbt.method_10569("type", playerData.hologramType.ordinal());
            playerNbt.method_10569("totalHolosCreated", playerData.totalHolosCreated);
            playerNbt.method_10569("lastComputerMaxPower", playerData.lastComputerMaxPower);
            playerData.clones.forEach(fakestPlayer -> {
                Log.info((LogCategory)LogCategory.GENERAL, (String)String.valueOf(fakestPlayer));
                class_2487 singleCloneNbt = new class_2487();
                fakestPlayer.actuallyWrite(singleCloneNbt);
                cloneNbt.method_10566(fakestPlayer.method_5667().toString(), (class_2520)singleCloneNbt);
            });
            playerNbt.method_10566("clones", (class_2520)cloneNbt);
            holoNbt.method_10566(uuid.toString(), (class_2520)playerNbt);
        });
        nbt.method_10566("players", (class_2520)holoNbt);
        return nbt;
    }

    public static class PlayerData {
        public boolean inHoloMode = false;
        public boolean loreAccurate = false;
        public HologramType hologramType = HologramType.NORMAL;
        public int totalHolosCreated = 0;
        public int lastComputerMaxPower = 0;
        public int power = 0;
        public String playerName = "";
        public String holoName = "";
        public ArrayList<FakestPlayer> clones = new ArrayList();
        public ArrayList<HoloModifiers> activeModifiers = new ArrayList();
        public class_2487 cloneCompound;
    }
}

