/*
 * Decompiled with CFR 0.152.
 */
package org.agmas.holo;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.command.v2.CommandRegistrationCallback;
import net.fabricmc.fabric.api.entity.event.v1.ServerPlayerEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerTickEvents;
import net.fabricmc.fabric.api.itemgroup.v1.ItemGroupEvents;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.fabric.api.resource.ResourceManagerHelper;
import net.fabricmc.fabric.api.resource.ResourcePackActivationType;
import net.fabricmc.loader.api.FabricLoader;
import net.fabricmc.loader.api.ModContainer;
import net.minecraft.class_124;
import net.minecraft.class_1293;
import net.minecraft.class_1294;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1320;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1935;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2186;
import net.minecraft.class_2487;
import net.minecraft.class_2561;
import net.minecraft.class_2596;
import net.minecraft.class_2661;
import net.minecraft.class_2703;
import net.minecraft.class_2784;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3330;
import net.minecraft.class_3336;
import net.minecraft.class_3414;
import net.minecraft.class_3417;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_5321;
import net.minecraft.class_5895;
import net.minecraft.class_5897;
import net.minecraft.class_6880;
import net.minecraft.class_7706;
import net.minecraft.class_7828;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.agmas.holo.ModBlocks;
import org.agmas.holo.ModEntities;
import org.agmas.holo.ModItems;
import org.agmas.holo.mixin.PlayerEntityAccessor;
import org.agmas.holo.state.HoloNbtManager;
import org.agmas.holo.terminalCommands.TerminalCommand;
import org.agmas.holo.terminalCommands.TerminalCommandParser;
import org.agmas.holo.util.BattleHologramComputerEntry;
import org.agmas.holo.util.FakestPlayer;
import org.agmas.holo.util.HoloModeUpdates;
import org.agmas.holo.util.HoloModifiers;
import org.agmas.holo.util.HologramType;
import org.agmas.holo.util.payloads.HoloModeSwitchS2CPacket;
import org.agmas.holo.util.payloads.HoloStatusInfoS2CPacket;
import org.agmas.holo.util.payloads.RequestTerminalAutocompleteC2SPacket;
import org.agmas.holo.util.payloads.SendTerminalAutocompleteS2CPacket;
import org.agmas.holo.util.payloads.SwapC2SPacket;
import org.agmas.holo.util.payloads.TemporarilyShowEntityS2CPacket;
import org.agmas.holo.util.payloads.TerminalCommandC2SPacket;

public class Holo
implements ModInitializer {
    public static final String MOD_ID = "holo";
    public static MinecraftServer server;
    public static HashMap<BattleHologramComputerEntry, ArrayList<class_1657>> playersWaitingForBattle;
    public static ArrayList<ArrayList<class_1657>> fights;
    public static Map<HoloModifiers, Integer> modifierToPower;
    public static List<HoloModifiers> loreAllowedModifiers;
    public static final class_8710.class_9154<SwapC2SPacket> SWAP_PACKET;
    public static final class_8710.class_9154<HoloModeSwitchS2CPacket> HOLO_MODE;
    public static final class_8710.class_9154<TerminalCommandC2SPacket> TERMINAL_COMMAND;
    public static final class_8710.class_9154<SendTerminalAutocompleteS2CPacket> SEND_TERMINAL_AUTOCOMPLETE;
    public static final class_8710.class_9154<RequestTerminalAutocompleteC2SPacket> REQUEST_TERMINAL_AUTOCOMPLETE;
    public static final class_8710.class_9154<TemporarilyShowEntityS2CPacket> TEMPORARILY_SHOW_ENTITY;
    public static final class_8710.class_9154<HoloStatusInfoS2CPacket> HOLO_STATUS_INFO;
    public static final class_2960 OPEN_BATTLE_COMPUTER_SCREEN;
    public static class_2960 HUMAN_DAMAGE_MODIFIER_ID;
    public static class_2960 HUMAN_DAMAGE_SPEED_MODIFIER_ID;
    public static class_2960 HUMAN_SPEED_MODIFIER_ID;
    public static class_2960 HUMAN_JUMP_MODIFIER_ID;

    public void onInitialize() {
        ModEntities.init();
        ModBlocks.initialize();
        HoloNbtManager.init();
        ModItems.initialize();
        TerminalCommandParser.initCommands();
        ResourceManagerHelper.registerBuiltinResourcePack((class_2960)class_2960.method_60655((String)MOD_ID, (String)"noholooverlay"), (ModContainer)((ModContainer)FabricLoader.getInstance().getModContainer(MOD_ID).get()), (ResourcePackActivationType)ResourcePackActivationType.NORMAL);
        PayloadTypeRegistry.playS2C().register(HoloModeSwitchS2CPacket.ID, HoloModeSwitchS2CPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(SendTerminalAutocompleteS2CPacket.ID, SendTerminalAutocompleteS2CPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(TemporarilyShowEntityS2CPacket.ID, TemporarilyShowEntityS2CPacket.CODEC);
        PayloadTypeRegistry.playS2C().register(HoloStatusInfoS2CPacket.ID, HoloStatusInfoS2CPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(SwapC2SPacket.ID, SwapC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(TerminalCommandC2SPacket.ID, TerminalCommandC2SPacket.CODEC);
        PayloadTypeRegistry.playC2S().register(RequestTerminalAutocompleteC2SPacket.ID, RequestTerminalAutocompleteC2SPacket.CODEC);
        CommandRegistrationCallback.EVENT.register((dispatcher, registryAccess, environment) -> {
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"clearPlayerHoloData").requires(serverCommandSource -> serverCommandSource.method_9259(2))).then(class_2170.method_9244((String)"player", (ArgumentType)class_2186.method_9305()).executes(commandContext -> {
                class_3222 entity = class_2186.method_9315((CommandContext)commandContext, (String)"player");
                entity.field_13987.method_14364((class_2596)new class_2661((class_2561)class_2561.method_43470((String)"Your holo data was reset by an admin\nYou will be put into human form the same way you were upon disconnecting.")));
                HoloNbtManager.INSTANCE.players.remove(entity.method_5667());
                return 1;
            })));
            dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"holo_loreMode").requires(serverCommandSource -> serverCommandSource.method_44023().method_5845().equals("5de5299b-83c1-4fe4-9c47-b8aae4fed6b1"))).executes(context -> {
                if (((class_2168)context.getSource()).method_44023() != null) {
                    Holo.switchShellMode((class_1657)((class_2168)context.getSource()).method_44023(), true, false);
                    HoloNbtManager.getPlayerState((class_1309)((class_2168)context.getSource()).method_44023()).loreAccurate = !HoloNbtManager.getPlayerState((class_1309)((class_2168)context.getSource()).method_44023()).loreAccurate;
                    Holo.getHumanAttributes((class_1657)((class_2168)context.getSource()).method_44023()).forEach((attributeEntry, modifier) -> {
                        if (((class_2168)context.getSource()).method_44023().method_5996(attributeEntry) != null && !((class_2168)context.getSource()).method_44023().method_5996(attributeEntry).method_6196(modifier.comp_2447())) {
                            ((class_2168)context.getSource()).method_44023().method_5996(attributeEntry).method_26837(modifier);
                        }
                    });
                }
                return 1;
            }));
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40205).register(t -> {
            t.method_45421((class_1935)ModItems.HOLOGRAM_SPAWN_EGG);
            t.method_45421((class_1935)ModItems.BATTLE_HOLOGRAM_SPAWN_EGG);
        });
        ItemGroupEvents.modifyEntriesEvent((class_5321)class_7706.field_40197).register(t -> {
            t.method_45421((class_1935)ModBlocks.HOLOGRAM_CONTROLLER);
            t.method_45421((class_1935)ModBlocks.BATTLE_HOLOGRAM_CONTROLLER);
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(srv -> {
            for (class_1657 player : srv.method_3760().method_14571()) {
                if (HoloNbtManager.getPlayerState((class_1309)player).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
                    Holo.swapBody(player, false, false);
                    Holo.updateAttributesAndUpdateMode(player);
                }
                for (FakestPlayer clone : HoloNbtManager.getPlayerState((class_1309)player).clones) {
                    player.method_37908().method_8503().method_3760().method_14581((class_2596)new class_7828(List.of(clone.method_5667())));
                    clone.method_5682().method_3760().method_14611((class_3222)clone);
                }
            }
        });
        ServerLifecycleEvents.SERVER_STARTED.register(srv -> {
            server = srv;
            fights.clear();
            playersWaitingForBattle.clear();
            HoloNbtManager.INSTANCE = server.method_30002().hasAttached(HoloNbtManager.holoData) ? HoloNbtManager.createFromNbt((class_2487)server.method_30002().getAttached(HoloNbtManager.holoData), srv) : new HoloNbtManager();
        });
        ServerLifecycleEvents.SERVER_STOPPING.register(srv -> {
            class_2487 holoDat = new class_2487();
            HoloNbtManager.getServerState(srv).writeNbt(holoDat);
            srv.method_30002().setAttached(HoloNbtManager.holoData, (Object)holoDat);
        });
        ServerPlayConnectionEvents.DISCONNECT.register((serverPlayNetworkHandler, minecraftServer) -> {
            for (FakestPlayer clone : HoloNbtManager.getPlayerState((class_1309)serverPlayNetworkHandler.field_14140).clones) {
                clone.method_5682().method_3760().method_14611((class_3222)clone);
            }
        });
        ArrayList bufferedKeys = new ArrayList();
        ServerPlayNetworking.registerGlobalReceiver(REQUEST_TERMINAL_AUTOCOMPLETE, (payload, context) -> {
            ArrayList<String> commands = new ArrayList<String>();
            for (TerminalCommand value : TerminalCommandParser.nameAndCommands.values()) {
                commands.addAll(value.autoCompletion(context.player()));
            }
            ServerPlayNetworking.send((class_3222)context.player(), (class_8710)new SendTerminalAutocompleteS2CPacket(commands));
        });
        ServerPlayNetworking.registerGlobalReceiver(TERMINAL_COMMAND, (payload, context) -> {
            String command = payload.command();
            if (HoloNbtManager.getPlayerState((class_1309)context.player()).inHoloMode) {
                if (HoloNbtManager.getPlayerState((class_1309)context.player()).hologramType != HologramType.BATTLE_DUEL) {
                    context.player().method_43496(TerminalCommandParser.findAndRunCommand(command, context.player()));
                } else {
                    context.player().method_43496((class_2561)class_2561.method_43470((String)"You can't use the terminal in a duel!").method_27692(class_124.field_1061));
                }
            }
        });
        ServerPlayNetworking.registerGlobalReceiver(SWAP_PACKET, (payload, context) -> {
            if (HoloNbtManager.getPlayerState((class_1309)context.player()).inHoloMode && !bufferedKeys.contains(context.player())) {
                bufferedKeys.add(context.player());
            }
        });
        ServerPlayerEvents.AFTER_RESPAWN.register((old, newPlayer, b) -> {
            if (HoloNbtManager.getPlayerState((class_1309)newPlayer).inHoloMode) {
                Holo.switchShellMode((class_1657)newPlayer, true, false);
            } else if (HoloNbtManager.getPlayerState((class_1309)newPlayer).loreAccurate) {
                newPlayer.method_5682().method_3760().method_14563().method_14633((class_3330)new class_3336(newPlayer.method_7334()));
                newPlayer.field_13987.method_14364((class_2596)new class_2661((class_2561)class_2561.method_43471((String)"multiplayer.disconnect.banned")));
            }
        });
        ServerPlayerEvents.ALLOW_DEATH.register((serverPlayerEntity, damageSource, v) -> {
            if (HoloNbtManager.getPlayerState((class_1309)serverPlayerEntity).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
                Holo.resetFromFight((class_1657)serverPlayerEntity);
                return false;
            }
            return true;
        });
        ServerTickEvents.END_SERVER_TICK.register(server -> {
            fights.removeIf(fight -> {
                fight.removeIf(p -> {
                    if (!(p.method_36608() && HoloNbtManager.getPlayerState((class_1309)p).inHoloMode && HoloNbtManager.getPlayerState((class_1309)p).hologramType.equals((Object)HologramType.BATTLE_DUEL))) {
                        Holo.resetFromFight(p);
                        return true;
                    }
                    return false;
                });
                if (fight.size() == 1) {
                    Holo.resetFromFight((class_1657)fight.get(0));
                    return true;
                }
                return fight.isEmpty();
            });
            for (Map.Entry<BattleHologramComputerEntry, ArrayList<class_1657>> entry : playersWaitingForBattle.entrySet()) {
                entry.getValue().removeIf(p -> p.method_37908() != ((BattleHologramComputerEntry)entry.getKey()).world || !p.method_36608());
                ArrayList<class_1657> fight2 = new ArrayList<class_1657>();
                if (entry.getValue().size() >= entry.getKey().count || entry.getValue().size() >= 2 && entry.getKey().start) {
                    entry.getKey().start = false;
                    int i2 = 0;
                    for (class_1657 player : entry.getValue()) {
                        FakestPlayer player1 = Holo.summonNewBody(player, HoloNbtManager.getPlayerState((class_1309)player).inHoloMode, HoloNbtManager.getPlayerState((class_1309)player).hologramType, HoloNbtManager.getPlayerState((class_1309)player).holoName);
                        FakestPlayer player2 = Holo.summonNewBody(player, true, HologramType.BATTLE_DUEL, "duel_holo_" + ++i2);
                        HoloNbtManager.getPlayerState((class_1309)player).inHoloMode = true;
                        HoloNbtManager.getPlayerState((class_1309)player).holoName = "duel_holo_" + i2;
                        HoloNbtManager.getPlayerState((class_1309)player).hologramType = HologramType.BATTLE_DUEL;
                        Holo.tinyPlayerClone((class_1657)((class_3222)player), player1);
                        Holo.tinyPlayerClone((class_1657)player2, (class_3222)player);
                        HoloNbtManager.getPlayerState((class_1309)player).clones.remove((Object)player2);
                        player.method_5859((double)entry.getKey().pos.method_10263(), (double)entry.getKey().pos.method_10264(), (double)entry.getKey().pos.method_10260());
                        player.method_37908().method_8503().method_3760().method_14581((class_2596)new class_7828(List.of(player1.method_5667())));
                        player2.method_5650(class_1297.class_5529.field_26999);
                        HoloModeUpdates.sendHoloModeUpdate(player);
                        fight2.add(player);
                        for (int i = 0; i < player.method_31548().method_5439(); ++i) {
                            player.method_31548().method_5447(i, player1.method_31548().method_5438(i).method_7972());
                        }
                        player.method_31548().method_5431();
                        class_2784 worldBorder = new class_2784();
                        worldBorder.method_11978((double)entry.getKey().pos.method_10263() * entry.getKey().world.method_8597().comp_646(), (double)entry.getKey().pos.method_10260() * entry.getKey().world.method_8597().comp_646());
                        worldBorder.method_11969(24.0);
                        if (!(player instanceof class_3222)) continue;
                        class_3222 spe = (class_3222)player;
                        if (!entry.getKey().infinite) {
                            spe.field_13987.method_14364((class_2596)new class_5895(worldBorder));
                            spe.field_13987.method_14364((class_2596)new class_5897(worldBorder));
                        }
                        spe.field_6008 = 100;
                    }
                    fights.add(fight2);
                    entry.getValue().clear();
                }
                for (class_1657 player : entry.getValue()) {
                    player.method_7353((class_2561)class_2561.method_43470((String)("Waiting for opponent.. (" + entry.getValue().size() + "/" + entry.getKey().count + ")")).method_27692(class_124.field_1065), true);
                }
            }
        });
        ServerTickEvents.END_SERVER_TICK.register(s -> s.method_3760().method_14571().forEach(p -> {
            ArrayList clonestoYoink = new ArrayList();
            HoloNbtManager.getPlayerState((class_1309)p).clones.removeIf(fp -> {
                if (!fp.method_5805()) {
                    clonestoYoink.add(fp);
                }
                return !fp.method_5805();
            });
            for (FakestPlayer fp2 : clonestoYoink) {
                fp2.method_5682().method_3760().method_14611((class_3222)fp2);
            }
        }));
        ServerTickEvents.START_WORLD_TICK.register(serverWorld -> {
            serverWorld.method_18456().forEach(p -> {
                if (HoloNbtManager.getPlayerState((class_1309)p).inHoloMode) {
                    if (!HoloNbtManager.getPlayerState((class_1309)p).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
                        Holo.refreshPower((class_1657)p);
                        if (HoloNbtManager.getPlayerState((class_1309)p).activeModifiers.contains((Object)HoloModifiers.NIGHT_VISION)) {
                            p.method_6092(new class_1293(class_1294.field_5925, 40, 0));
                        }
                        if (HoloNbtManager.getPlayerState((class_1309)p).activeModifiers.contains((Object)HoloModifiers.GLIDER)) {
                            p.method_6092(new class_1293(class_1294.field_5906, 40, 0));
                        }
                        if (serverWorld.method_8510() % 10L == 0L) {
                            Holo.sendHoloStatusUpdate(p);
                        }
                        if (HoloNbtManager.getPlayerState((class_1309)p).power > 4 + 4 * HoloNbtManager.getPlayerState((class_1309)p).lastComputerMaxPower) {
                            p.method_6092(new class_1293(class_1294.field_5919, 40, 0));
                            if (serverWorld.method_8510() % 10L == 0L) {
                                p.method_17356((class_3414)class_3417.field_18312.comp_349(), class_3419.field_15250, 1.0f, 1.0f);
                                p.method_5643(p.method_48923().method_48809(), 2.0f);
                                if (p.method_6032() < 4.0f) {
                                    bufferedKeys.add(p);
                                    p.method_43496((class_2561)class_2561.method_43470((String)"You were kicked out of that hologram for reckless power usage. ").method_10852((class_2561)class_2561.method_43470((String)"Please use less power.").method_27692(class_124.field_1061)));
                                }
                                p.method_7353((class_2561)class_2561.method_43470((String)"Decrease your power usage!").method_27692(class_124.field_1061), true);
                            }
                        }
                    }
                    if (HoloNbtManager.getPlayerState((class_1309)p).hologramType.equals((Object)HologramType.BATTLE) || HoloNbtManager.getPlayerState((class_1309)p).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
                        p.method_7344().method_7580(19);
                    } else {
                        p.method_7344().method_7580(20);
                    }
                }
            });
            for (class_3222 bufferPlayer : bufferedKeys) {
                if (!bufferedKeys.contains(bufferPlayer)) continue;
                FakestPlayer fakestPlayer = HoloNbtManager.getPlayerState((class_1309)bufferPlayer).clones.get(0);
                Holo.swapBody((class_1657)bufferPlayer, fakestPlayer, !HoloNbtManager.getPlayerState((class_1309)bufferPlayer).hologramType.equals((Object)HologramType.BATTLE_DUEL));
                Holo.updateAttributesAndUpdateMode((class_1657)bufferPlayer);
            }
            bufferedKeys.clear();
        });
    }

    public static void sendHoloStatusUpdate(class_3222 p) {
        FakestPlayer human = null;
        for (FakestPlayer clone : HoloNbtManager.getPlayerState((class_1309)p).clones) {
            if (clone.isHologram) continue;
            human = clone;
            break;
        }
        if (human != null) {
            int playersAlive = 0;
            if (HoloNbtManager.getPlayerState((class_1309)p).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
                for (ArrayList<class_1657> fight : fights) {
                    if (!fight.contains(p)) continue;
                    playersAlive += fight.size() - 1;
                    break;
                }
            }
            ServerPlayNetworking.send((class_3222)p, (class_8710)new HoloStatusInfoS2CPacket(HoloNbtManager.getPlayerState((class_1309)p).holoName, (int)human.method_6032(), HoloNbtManager.getPlayerState((class_1309)p).power, 4 + 4 * HoloNbtManager.getPlayerState((class_1309)p).lastComputerMaxPower, playersAlive));
        }
    }

    public static void refreshPower(class_1657 p) {
        HoloNbtManager.getPlayerState((class_1309)p).power = HoloNbtManager.getPlayerState((class_1309)p).clones.size();
        if (p.method_6032() < 5.0f) {
            ++HoloNbtManager.getPlayerState((class_1309)p).power;
        }
        if (p.method_37908().method_8597().method_44220() || p.method_5809()) {
            ++HoloNbtManager.getPlayerState((class_1309)p).power;
        }
        if (HoloNbtManager.getPlayerState((class_1309)p).loreAccurate) {
            HoloNbtManager.getPlayerState((class_1309)p).power = 0;
        }
        if (p.method_5869()) {
            ++HoloNbtManager.getPlayerState((class_1309)p).power;
        }
        for (HoloModifiers activeModifier : HoloNbtManager.getPlayerState((class_1309)p).activeModifiers) {
            HoloNbtManager.getPlayerState((class_1309)p).power += modifierToPower.get((Object)activeModifier).intValue();
        }
    }

    public static void resetFromFight(class_1657 player) {
        if (player.method_36608() && HoloNbtManager.getPlayerState((class_1309)player).inHoloMode && HoloNbtManager.getPlayerState((class_1309)player).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
            Holo.swapBody(player, false, false);
        }
        Holo.updateAttributesAndUpdateMode(player);
        if (player instanceof class_3222) {
            class_3222 spe = (class_3222)player;
            spe.field_13987.method_14364((class_2596)new class_5895(player.method_37908().method_8621()));
            spe.field_13987.method_14364((class_2596)new class_5897(player.method_37908().method_8621()));
        }
    }

    public static UUID getFreeUUID() {
        UUID uuid = UUID.randomUUID();
        if (server.method_3793() != null) {
            while (server.method_3793().method_14512(uuid).isPresent()) {
                uuid = UUID.randomUUID();
            }
        }
        return uuid;
    }

    public static void tinyPlayerClone(class_1657 original, class_3222 clone) {
        clone.method_31548().method_7377(original.method_31548());
        clone.method_6033(original.method_6032());
        clone.method_7344().method_7581(original.method_7344().method_7589());
        clone.method_7344().method_35218(original.method_7344().method_35219());
        clone.method_7344().method_7580(original.method_7344().method_7586());
        clone.field_7520 = original.field_7520;
        clone.field_7495 = original.field_7495;
        clone.method_6033(original.method_6032());
        clone.field_7510 = original.field_7510;
        clone.method_7320(original.method_7272());
        if (original instanceof class_3222) {
            class_3222 spe = (class_3222)original;
            clone.method_7336(spe.field_13974.method_14257());
            clone.method_5841().method_12778(((PlayerEntityAccessor)clone).PLAYER_MODEL_PARTS(), (Object)((byte)spe.method_53823().comp_1955()));
        }
        clone.method_20803(original.method_20802());
        clone.field_6008 = 0;
        clone.field_6017 = original.field_6017;
        clone.method_14234();
        clone.method_31548().method_5431();
        clone.field_6008 = original.field_6008;
        clone.method_14226();
        clone.method_14251((class_3218)original.method_37908(), original.method_19538().field_1352, original.method_19538().field_1351, original.method_19538().field_1350, original.method_36454(), original.method_36455());
    }

    public static ImmutableMultimap<class_6880<class_1320>, class_1322> getHoloAttributes(class_1657 player) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (!HoloNbtManager.getPlayerState((class_1309)player).loreAccurate) {
            if (!HoloNbtManager.getPlayerState((class_1309)player).hologramType.equals((Object)HologramType.BATTLE)) {
                builder.put((Object)class_5134.field_23721, (Object)new class_1322(HUMAN_DAMAGE_MODIFIER_ID, -100.0, class_1322.class_1323.field_6328));
            } else {
                builder.put((Object)class_5134.field_23721, (Object)new class_1322(HUMAN_DAMAGE_MODIFIER_ID, -4.5, class_1322.class_1323.field_6328));
            }
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(HUMAN_DAMAGE_SPEED_MODIFIER_ID, -0.9, class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23719, (Object)new class_1322(HUMAN_SPEED_MODIFIER_ID, -0.075, class_1322.class_1323.field_6328));
        }
        return builder.build();
    }

    public static ImmutableMultimap<class_6880<class_1320>, class_1322> getHumanAttributes(class_1657 player) {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        if (HoloNbtManager.getPlayerState((class_1309)player).loreAccurate) {
            builder.put((Object)class_5134.field_23721, (Object)new class_1322(HUMAN_DAMAGE_MODIFIER_ID, -3.5, class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23723, (Object)new class_1322(HUMAN_DAMAGE_SPEED_MODIFIER_ID, -0.8, class_1322.class_1323.field_6328));
            builder.put((Object)class_5134.field_23719, (Object)new class_1322(HUMAN_SPEED_MODIFIER_ID, -0.045, class_1322.class_1323.field_6328));
        }
        return builder.build();
    }

    public static boolean canSwapBody(class_1657 player, boolean holo) {
        Object bodyToTake = null;
        for (FakestPlayer clone : HoloNbtManager.getPlayerState((class_1309)player).clones) {
            if (clone.isHologram != holo) continue;
            return true;
        }
        return false;
    }

    public static void swapBody(class_1657 player, FakestPlayer bodyToTake, boolean bodyStays) {
        player.method_29239();
        if (bodyStays) {
            Holo.summonBody(player);
        }
        if (bodyToTake != null) {
            HoloNbtManager.getPlayerState((class_1309)player).clones.remove((Object)bodyToTake);
            HoloNbtManager.getPlayerState((class_1309)player).inHoloMode = bodyToTake.isHologram;
            HoloNbtManager.getPlayerState((class_1309)player).holoName = bodyToTake.holoName;
            HoloNbtManager.getPlayerState((class_1309)player).hologramType = bodyToTake.type;
            Holo.tinyPlayerClone((class_1657)bodyToTake, (class_3222)player);
            player.method_5859(bodyToTake.method_19538().field_1352, bodyToTake.method_19538().field_1351, bodyToTake.method_19538().field_1350);
            Holo.sendHoloStatusUpdate((class_3222)player);
            player.method_37908().method_8503().method_3760().method_14581((class_2596)new class_7828(List.of(bodyToTake.method_5667())));
            bodyToTake.method_5650(class_1297.class_5529.field_26999);
        }
    }

    public static void swapBody(class_1657 player, boolean holo, boolean bodyStays) {
        player.method_29239();
        if (bodyStays) {
            Holo.summonBody(player);
        }
        FakestPlayer bodyToTake = null;
        for (FakestPlayer clone : HoloNbtManager.getPlayerState((class_1309)player).clones) {
            if (clone.isHologram != holo) continue;
            bodyToTake = clone;
            break;
        }
        if (bodyToTake != null) {
            HoloNbtManager.getPlayerState((class_1309)player).inHoloMode = holo;
            HoloNbtManager.getPlayerState((class_1309)player).holoName = bodyToTake.holoName;
            if (holo) {
                HoloNbtManager.getPlayerState((class_1309)player).hologramType = bodyToTake.type;
            }
            Holo.tinyPlayerClone((class_1657)bodyToTake, (class_3222)player);
            player.method_5859(bodyToTake.method_19538().field_1352, bodyToTake.method_19538().field_1351, bodyToTake.method_19538().field_1350);
            HoloNbtManager.getPlayerState((class_1309)player).clones.remove((Object)bodyToTake);
            Holo.sendHoloStatusUpdate((class_3222)player);
            player.method_37908().method_8503().method_3760().method_14581((class_2596)new class_7828(List.of(bodyToTake.method_5667())));
            bodyToTake.method_5650(class_1297.class_5529.field_26999);
        }
    }

    private static void summonBody(class_1657 player) {
        Holo.summonBody(player, HoloNbtManager.getPlayerState((class_1309)player).inHoloMode);
    }

    public static FakestPlayer summonNewBody(class_1657 player, boolean holoMode, HologramType type, String holoName) {
        FakestPlayer fp;
        GameProfile profile = new GameProfile(Holo.getFreeUUID(), "");
        profile.getProperties().putAll((Multimap)player.method_7334().getProperties());
        FakestPlayer fakePlayer = FakestPlayer.get((class_3218)player.method_37908(), profile, player.method_5820(), player.method_5667());
        if (player instanceof FakestPlayer) {
            fp = (FakestPlayer)player;
            fakePlayer.ownerUUID = fp.ownerUUID;
            fakePlayer.ownerName = fp.ownerName;
        }
        player.method_37908().method_8503().method_3760().method_14581((class_2596)class_2703.method_43886(List.of(fakePlayer)));
        fakePlayer.method_51468((class_3218)player.method_37908());
        fakePlayer.method_5808(player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        if (player instanceof class_3222) {
            fp = (class_3222)player;
            fakePlayer.method_5841().method_12778(((PlayerEntityAccessor)((Object)fakePlayer)).PLAYER_MODEL_PARTS(), (Object)((byte)fp.method_53823().comp_1955()));
        }
        ((class_3218)player.method_37908()).method_18213((class_3222)fakePlayer);
        fakePlayer.isHologram = holoMode;
        fakePlayer.type = type;
        fakePlayer.holoName = holoName;
        if (!fakePlayer.isHologram) {
            fakePlayer.holoName = player.method_5477().getString();
        }
        if (fakePlayer.isHologram) {
            HoloModeUpdates.sendHoloModeUpdate((class_1657)fakePlayer);
        }
        fakePlayer.worldName = player.method_37908().method_27983();
        if (!(player instanceof FakestPlayer)) {
            HoloNbtManager.getPlayerState((class_1309)player).clones.add(fakePlayer);
            HoloNbtManager.getPlayerState((class_1309)player).playerName = player.method_5820();
        }
        player.method_37908().method_8503().method_3856();
        return fakePlayer;
    }

    public static void summonBody(class_1657 player, boolean holoMode) {
        FakestPlayer fakePlayer = Holo.summonNewBody(player, holoMode, HoloNbtManager.getPlayerState((class_1309)player).hologramType, HoloNbtManager.getPlayerState((class_1309)player).holoName);
        Holo.tinyPlayerClone(player, fakePlayer);
    }

    public static void switchShellMode(class_1657 player, boolean shell, boolean bodyStays) {
        Holo.swapBody(player, !shell, bodyStays);
        Holo.updateAttributesAndUpdateMode(player);
    }

    public static void updateAttributesForModifiers(class_1657 player, boolean refresh) {
        if (HoloNbtManager.getPlayerState((class_1309)player).inHoloMode) {
            if (refresh && !HoloNbtManager.getPlayerState((class_1309)player).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
                Holo.getHoloAttributes(player).forEach((attributeEntry, modifier) -> {
                    if (player.method_5996(attributeEntry) != null && !player.method_5996(attributeEntry).method_6196(modifier.comp_2447())) {
                        player.method_5996(attributeEntry).method_26837(modifier);
                    }
                });
            }
            if (HoloNbtManager.getPlayerState((class_1309)player).activeModifiers.contains((Object)HoloModifiers.MOBILITY)) {
                player.method_5996(class_5134.field_23719).method_6200(HUMAN_SPEED_MODIFIER_ID);
            }
            if (HoloNbtManager.getPlayerState((class_1309)player).activeModifiers.contains((Object)HoloModifiers.OFFENSE)) {
                player.method_5996(class_5134.field_23721).method_6200(HUMAN_DAMAGE_MODIFIER_ID);
                player.method_5996(class_5134.field_23723).method_6200(HUMAN_DAMAGE_SPEED_MODIFIER_ID);
            }
        }
    }

    public static void updateAttributesAndUpdateMode(class_1657 player) {
        if (HoloNbtManager.getPlayerState((class_1309)player).inHoloMode) {
            if (!HoloNbtManager.getPlayerState((class_1309)player).hologramType.equals((Object)HologramType.BATTLE_DUEL)) {
                Holo.getHoloAttributes(player).forEach((attributeEntry, modifier) -> {
                    if (player.method_5996(attributeEntry) != null && !player.method_5996(attributeEntry).method_6196(modifier.comp_2447())) {
                        player.method_5996(attributeEntry).method_26837(modifier);
                    }
                });
            }
            player.method_6127().method_59935(Holo.getHumanAttributes(player));
            HoloModeUpdates.sendHoloModeUpdate(player);
            Holo.updateAttributesForModifiers(player, false);
        } else {
            HoloNbtManager.getPlayerState((class_1309)player).hologramType = HologramType.NORMAL;
            Holo.getHumanAttributes(player).forEach((attributeEntry, modifier) -> {
                if (player.method_5996(attributeEntry) != null && !player.method_5996(attributeEntry).method_6196(modifier.comp_2447())) {
                    player.method_5996(attributeEntry).method_26837(modifier);
                }
            });
            player.method_6127().method_59935(Holo.getHoloAttributes(player));
            HoloModeUpdates.sendHumanModeUpdate(player);
        }
    }

    static {
        playersWaitingForBattle = new HashMap();
        fights = new ArrayList();
        modifierToPower = ImmutableMap.of((Object)((Object)HoloModifiers.OFFENSE), (Object)2, (Object)((Object)HoloModifiers.MOBILITY), (Object)1, (Object)((Object)HoloModifiers.NIGHT_VISION), (Object)3, (Object)((Object)HoloModifiers.GLIDER), (Object)3, (Object)((Object)HoloModifiers.CONSTRUCTION), (Object)2);
        loreAllowedModifiers = List.of(HoloModifiers.NIGHT_VISION, HoloModifiers.GLIDER);
        SWAP_PACKET = SwapC2SPacket.ID;
        HOLO_MODE = HoloModeSwitchS2CPacket.ID;
        TERMINAL_COMMAND = TerminalCommandC2SPacket.ID;
        SEND_TERMINAL_AUTOCOMPLETE = SendTerminalAutocompleteS2CPacket.ID;
        REQUEST_TERMINAL_AUTOCOMPLETE = RequestTerminalAutocompleteC2SPacket.ID;
        TEMPORARILY_SHOW_ENTITY = TemporarilyShowEntityS2CPacket.ID;
        HOLO_STATUS_INFO = HoloStatusInfoS2CPacket.ID;
        OPEN_BATTLE_COMPUTER_SCREEN = class_2960.method_60655((String)MOD_ID, (String)"open_battle_computer_screen");
        HUMAN_DAMAGE_MODIFIER_ID = class_2960.method_60655((String)MOD_ID, (String)"human_damage");
        HUMAN_DAMAGE_SPEED_MODIFIER_ID = class_2960.method_60655((String)MOD_ID, (String)"human_damage_speed");
        HUMAN_SPEED_MODIFIER_ID = class_2960.method_60655((String)MOD_ID, (String)"human_speed");
        HUMAN_JUMP_MODIFIER_ID = class_2960.method_60655((String)MOD_ID, (String)"human_health");
    }
}

